package org.gcube.data.transfer.service;

import javax.ws.rs.ApplicationPath;

import org.gcube.data.transfer.model.ServiceConstants;
import org.gcube.data.transfer.service.transfers.Capabilities;
import org.gcube.data.transfer.service.transfers.REST;
import org.gcube.data.transfer.service.transfers.Requests;
import org.gcube.data.transfer.service.transfers.TransferStatus;
import org.gcube.data.transfer.service.transfers.engine.AccountingManager;
import org.gcube.data.transfer.service.transfers.engine.CapabilitiesProvider;
import org.gcube.data.transfer.service.transfers.engine.PersistenceProvider;
import org.gcube.data.transfer.service.transfers.engine.PluginManager;
import org.gcube.data.transfer.service.transfers.engine.RequestManager;
import org.gcube.data.transfer.service.transfers.engine.TicketManager;
import org.gcube.data.transfer.service.transfers.engine.impl.AccountingManagerImpl;
import org.gcube.data.transfer.service.transfers.engine.impl.CapabilitiesProviderImpl;
import org.gcube.data.transfer.service.transfers.engine.impl.PersistenceProviderImpl;
import org.gcube.data.transfer.service.transfers.engine.impl.PluginManagerImpl;
import org.gcube.data.transfer.service.transfers.engine.impl.RequestManagerImpl;
import org.gcube.data.transfer.service.transfers.engine.impl.TransferTicketManagerImpl;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;

@ApplicationPath(ServiceConstants.APPLICATION_PATH)
public class DTService extends ResourceConfig{

	public DTService() {
		super();
		
		AbstractBinder binder = new AbstractBinder() {
            @Override
            protected void configure() {                    
              bind(AccountingManagerImpl.class).to(AccountingManager.class);
              bind(CapabilitiesProviderImpl.class).to(CapabilitiesProvider.class);
              bind(PersistenceProviderImpl.class).to(PersistenceProvider.class);
              bind(PluginManagerImpl.class).to(PluginManager.class);
              bind(RequestManagerImpl.class).to(RequestManager.class);
              bind(TransferTicketManagerImpl.class).to(TicketManager.class);
            }
        };
		register(binder);
		
		register(Capabilities.class);
		register(Requests.class);
		register(REST.class);
		register(TransferStatus.class);
//		packages("org.gcube.data.transfer.service.transfers");
		packages("org.glassfish.jersey.media.multipart");
		packages("org.glassfish.jersey.media.multipart.internal");
//		register(ProviderLoggingListener.class);
		register(MultiPartFeature.class);
	}
	
}
