/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.service.transfers.engine.impl;

import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.transfer.model.TransferRequest;
import org.gcube.data.transfer.model.TransferTicket;
import org.gcube.data.transfer.model.options.TransferOptions;
import org.gcube.data.transfer.service.transfers.engine.PersistenceProvider;
import org.gcube.data.transfer.service.transfers.engine.PluginManager;
import org.gcube.data.transfer.service.transfers.engine.RequestManager;
import org.gcube.data.transfer.service.transfers.engine.TicketManager;
import org.gcube.data.transfer.service.transfers.engine.impl.LocalRequestHandler;
import org.gcube.data.transfer.service.transfers.engine.impl.RequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RequestManagerImpl
implements RequestManager {
    private static final Logger log = LoggerFactory.getLogger(RequestManagerImpl.class);
    ExecutorService executor = Executors.newCachedThreadPool();
    TicketManager ticketManager;
    PersistenceProvider persistenceProvider;
    PluginManager pluginManager;

    @Inject
    public RequestManagerImpl(TicketManager ticketManager, PersistenceProvider persistenceProvider, PluginManager pluginManager) {
        this.persistenceProvider = persistenceProvider;
        this.pluginManager = pluginManager;
        this.ticketManager = ticketManager;
    }

    public TransferTicket put(TransferRequest request) {
        request.setId(UUID.randomUUID().toString());
        log.info("Managing request {} ", (Object)request);
        TransferTicket toReturn = new TransferTicket(request);
        if (request.getSettings().getOptions().getMethod().equals((Object)TransferOptions.TransferMethod.FileUpload)) {
            log.debug("Request is sync");
            return new LocalRequestHandler(this.persistenceProvider, this.pluginManager, toReturn).handle();
        }
        log.debug("Request is async");
        this.executor.execute((Runnable)new RequestHandler(this.ticketManager, new TransferTicket(request), this.persistenceProvider, this.pluginManager));
        return toReturn;
    }

    public void shutdown() {
        log.debug("Calling shutdown..");
        this.executor.shutdownNow();
        long timeout = 4L;
        TimeUnit unit = TimeUnit.SECONDS;
        log.debug("Waiting termination.. {} {} ", (Object)timeout, (Object)unit);
        boolean halted = false;
        try {
            halted = this.executor.awaitTermination(timeout, unit);
        }
        catch (InterruptedException e) {
            log.debug("Halted threads : {} ", (Object)halted);
        }
    }
}

