/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.service.transfers.engine.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.transfer.model.TransferRequest;
import org.gcube.data.transfer.service.transfers.engine.PersistenceProvider;
import org.gcube.data.transfer.service.transfers.engine.PluginManager;
import org.gcube.data.transfer.service.transfers.engine.RequestManager;
import org.gcube.data.transfer.service.transfers.engine.TicketManager;
import org.gcube.data.transfer.service.transfers.engine.impl.RequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RequestManagerImpl
implements RequestManager {
    private static final Logger log = LoggerFactory.getLogger(RequestManagerImpl.class);
    ExecutorService executor;
    private TicketManager ticketManager;
    private PersistenceProvider persistenceProvider;
    private PluginManager pluginManager;

    @Inject
    public RequestManagerImpl(TicketManager ticketManager, PersistenceProvider persistenceProvider, PluginManager pluginManager) {
        this.ticketManager = ticketManager;
        this.persistenceProvider = persistenceProvider;
        this.executor = Executors.newCachedThreadPool();
        this.pluginManager = pluginManager;
    }

    public boolean put(TransferRequest request) {
        try {
            this.executor.execute((Runnable)new RequestHandler(request, this.ticketManager, this.persistenceProvider, this.pluginManager));
            return true;
        }
        catch (Exception e) {
            log.debug("Unexpected Error while creating handler", (Throwable)e);
            return false;
        }
    }
}

