/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.plugin;

import org.gcube.data.transfer.model.ExecutionReport;
import org.gcube.data.transfer.model.PluginInvocation;
import org.gcube.data.transfer.plugin.fails.ParameterException;
import org.gcube.data.transfer.plugin.fails.PluginCleanupException;
import org.gcube.data.transfer.plugin.fails.PluginException;
import org.gcube.data.transfer.plugin.fails.PluginExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPlugin {
    private static final Logger log = LoggerFactory.getLogger(AbstractPlugin.class);
    protected PluginInvocation invocation;

    public AbstractPlugin(PluginInvocation invocation) {
        this.invocation = invocation;
    }

    public ExecutionReport execute() {
        log.trace("Executing : {}", (Object)this.invocation);
        try {
            log.debug("Calling run method, invocation is {} ", (Object)this.invocation);
            ExecutionReport report = this.run();
            log.debug("Calling cleanup, report was {}", (Object)report);
            this.cleanup();
            log.trace("Returning report {} for invocation {} ", (Object)report, (Object)this.invocation);
            return report;
        }
        catch (Throwable t) {
            log.debug("Thrown exception", t);
            return AbstractPlugin.fromException(this.invocation, t);
        }
    }

    public abstract ExecutionReport run() throws PluginExecutionException;

    public abstract void cleanup() throws PluginCleanupException;

    protected static ExecutionReport fromException(PluginInvocation invocation, Throwable t) {
        if (t instanceof PluginException) {
            if (t instanceof ParameterException) {
                return new ExecutionReport(invocation, t.getMessage(), ExecutionReport.ExecutionReportFlag.WRONG_PARAMETER);
            }
            if (t instanceof PluginCleanupException) {
                return new ExecutionReport(invocation, t.getMessage(), ExecutionReport.ExecutionReportFlag.FAILED_CLEANUP);
            }
            if (t instanceof PluginExecutionException) {
                return new ExecutionReport(invocation, t.getMessage(), ExecutionReport.ExecutionReportFlag.FAILED_EXECUTION);
            }
            if (t instanceof PluginCleanupException) {
                return new ExecutionReport(invocation, t.getMessage(), ExecutionReport.ExecutionReportFlag.FAILED_CLEANUP);
            }
            log.error("Unable to handle Plugin exception {}, invocation was {}", (Object)t.getMessage(), (Object)invocation);
            log.debug("Exception was ", t);
            throw new RuntimeException("Unhandled case : ", t);
        }
        return new ExecutionReport(invocation, t.getMessage(), ExecutionReport.ExecutionReportFlag.UNABLE_TO_EXECUTE);
    }
}

