/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.plugin;

import org.gcube.data.transfer.model.PluginInvocation;
import org.gcube.data.transfer.plugin.ExecutionReport;
import org.gcube.data.transfer.plugin.fails.PluginCleanupException;
import org.gcube.data.transfer.plugin.fails.PluginExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPlugin {
    private static final Logger log = LoggerFactory.getLogger(AbstractPlugin.class);
    protected PluginInvocation invocation;

    public AbstractPlugin(PluginInvocation invocation) {
        this.invocation = invocation;
    }

    public ExecutionReport execute() {
        log.trace("Executing : {}", (Object)this.invocation);
        try {
            log.debug("Calling run method, invocation is {} ", (Object)this.invocation);
            ExecutionReport report = this.run();
            log.debug("Calling cleanup, report was {}", (Object)report);
            this.cleanup();
            log.trace("Returning report {} for invocation {} ", (Object)report, (Object)this.invocation);
            return report;
        }
        catch (Throwable t) {
            log.debug("Thrown exception", t);
            return ExecutionReport.fromException(this.invocation, t);
        }
    }

    public abstract ExecutionReport run() throws PluginExecutionException;

    public abstract void cleanup() throws PluginCleanupException;
}

