/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.plugin;

import java.beans.ConstructorProperties;
import org.gcube.data.transfer.model.PluginInvocation;
import org.gcube.data.transfer.plugin.fails.ParameterException;
import org.gcube.data.transfer.plugin.fails.PluginCleanupException;
import org.gcube.data.transfer.plugin.fails.PluginException;
import org.gcube.data.transfer.plugin.fails.PluginExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionReport {
    private static final Logger log = LoggerFactory.getLogger(ExecutionReport.class);
    private PluginInvocation invocation;
    private String message;
    private ExecutionReportFlag flag;

    public static ExecutionReport fromException(PluginInvocation invocation, Throwable t) {
        if (t instanceof PluginException) {
            if (t instanceof ParameterException) {
                return new ExecutionReport(invocation, t.getMessage(), ExecutionReportFlag.WRONG_PARAMETER);
            }
            if (t instanceof PluginCleanupException) {
                return new ExecutionReport(invocation, t.getMessage(), ExecutionReportFlag.FAILED_CLEANUP);
            }
            if (t instanceof PluginExecutionException) {
                return new ExecutionReport(invocation, t.getMessage(), ExecutionReportFlag.FAILED_EXECUTION);
            }
            if (t instanceof PluginCleanupException) {
                return new ExecutionReport(invocation, t.getMessage(), ExecutionReportFlag.FAILED_CLEANUP);
            }
            log.error("Unable to handle Plugin exception {}, invocation was {}", (Object)t.getMessage(), (Object)invocation);
            log.debug("Exception was ", t);
            throw new RuntimeException("Unhandled case : ", t);
        }
        return new ExecutionReport(invocation, t.getMessage(), ExecutionReportFlag.UNABLE_TO_EXECUTE);
    }

    public String toString() {
        return "ExecutionReport(invocation=" + this.invocation + ", message=" + this.message + ", flag=" + (Object)((Object)this.flag) + ")";
    }

    @ConstructorProperties(value={"invocation", "message", "flag"})
    public ExecutionReport(PluginInvocation invocation, String message, ExecutionReportFlag flag) {
        this.invocation = invocation;
        this.message = message;
        this.flag = flag;
    }

    public static enum ExecutionReportFlag {
        SUCCESS,
        WRONG_PARAMETER,
        UNABLE_TO_EXECUTE,
        FAILED_EXECUTION,
        FAILED_CLEANUP;

    }
}

