/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.library.client;

import java.io.InputStream;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.gcube.data.transfer.library.client.AuthorizationFilter;
import org.gcube.data.transfer.library.faults.CommunicationException;
import org.gcube.data.transfer.library.faults.RemoteServiceException;
import org.gcube.data.transfer.library.faults.ServiceNotFoundException;
import org.gcube.data.transfer.model.RemoteFileDescriptor;
import org.gcube.data.transfer.model.TransferCapabilities;
import org.gcube.data.transfer.model.TransferRequest;
import org.gcube.data.transfer.model.TransferTicket;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client {
    private static final Logger log = LoggerFactory.getLogger(Client.class);
    private static ClientConfig config = null;
    private String endpoint;
    private WebTarget rootTarget;

    public Client(String endpoint) throws ServiceNotFoundException {
        try {
            log.debug("Creating client for base " + endpoint);
            this.endpoint = endpoint + "";
            this.rootTarget = ClientBuilder.newClient((Configuration)config).target(endpoint).path("data-transfer-service").path("/gcube/service/");
            log.debug("Root Taget IS {} ", (Object)this.rootTarget.getUri());
        }
        catch (Exception e) {
            throw new ServiceNotFoundException(e);
        }
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public TransferCapabilities getCapabilties() throws CommunicationException {
        WebTarget capabilitiesTarget = this.rootTarget.path("Capabilities");
        log.debug("Getting capabilities from {}, path is {} ", (Object)this.endpoint, (Object)capabilitiesTarget.getUri());
        try {
            Response resp = capabilitiesTarget.request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
            this.checkResponse(resp);
            return (TransferCapabilities)resp.readEntity(TransferCapabilities.class);
        }
        catch (Exception e) {
            throw new CommunicationException(e);
        }
    }

    public TransferTicket submit(TransferRequest request) throws RemoteServiceException {
        log.debug("Sending request {} to {}", (Object)request, (Object)this.endpoint);
        try {
            Response resp = this.rootTarget.path("Requests").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)request, (MediaType)MediaType.APPLICATION_JSON_TYPE));
            this.checkResponse(resp);
            return (TransferTicket)resp.readEntity(TransferTicket.class);
        }
        catch (Exception e) {
            throw new RemoteServiceException(e);
        }
    }

    public TransferTicket getTransferStatus(String transferId) throws RemoteServiceException {
        log.debug("Requesting transfer status [id = {}, endpoint={}]", (Object)transferId, (Object)this.endpoint);
        try {
            Response resp = this.rootTarget.path("TransferStatus").path(transferId).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
            this.checkResponse(resp);
            return (TransferTicket)resp.readEntity(TransferTicket.class);
        }
        catch (Exception e) {
            throw new RemoteServiceException(e);
        }
    }

    protected void checkResponse(Response toCheck) throws Exception {
        switch (toCheck.getStatusInfo().getFamily()) {
            case SUCCESSFUL: {
                break;
            }
            default: {
                throw new Exception("Unexpected Response code : " + toCheck.getStatus());
            }
        }
    }

    public void delete(RemoteFileDescriptor remote) throws RemoteServiceException {
        this.delete(remote.getPersistenceId() + "/" + remote.getPath());
    }

    public RemoteFileDescriptor getInfo(RemoteFileDescriptor remote) throws RemoteServiceException {
        return this.getInfo(remote.getPersistenceId() + "/" + remote.getPath());
    }

    public InputStream getInputStream(RemoteFileDescriptor remote) throws RemoteServiceException {
        return this.getInputStream(remote.getPersistenceId() + "/" + remote.getPath());
    }

    public void delete(String path) throws RemoteServiceException {
        log.debug("Deleting {} at []", (Object)path, (Object)this.endpoint);
        try {
            Response resp = this.rootTarget.path("REST").path(path).request().delete();
            this.checkResponse(resp);
        }
        catch (Exception e) {
            throw new RemoteServiceException(e);
        }
    }

    public RemoteFileDescriptor getInfo(String path) throws RemoteServiceException {
        log.debug("GetInfo of {} at []", (Object)path, (Object)this.endpoint);
        try {
            Response resp = this.rootTarget.path("REST").path(path).queryParam("descriptor", new Object[]{true}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
            this.checkResponse(resp);
            return (RemoteFileDescriptor)resp.readEntity(RemoteFileDescriptor.class);
        }
        catch (Exception e) {
            throw new RemoteServiceException(e);
        }
    }

    public InputStream getInputStream(String path) throws RemoteServiceException {
        log.debug("Get InputStream of {} at []", (Object)path, (Object)this.endpoint);
        try {
            Response resp = this.rootTarget.path("REST").path(path).queryParam("descriptor", new Object[]{true}).request().get();
            this.checkResponse(resp);
            return (InputStream)resp.readEntity(InputStream.class);
        }
        catch (Exception e) {
            throw new RemoteServiceException(e);
        }
    }

    static {
        log.debug("Creating configuration ..");
        config = new ClientConfig();
        config.register(JacksonFeature.class);
        config.register(AuthorizationFilter.class);
    }
}

