/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.library.client;

import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBElement;
import org.gcube.data.transfer.library.client.AuthorizationFilter;
import org.gcube.data.transfer.model.TransferCapabilities;
import org.gcube.data.transfer.model.TransferRequest;
import org.gcube.data.transfer.model.TransferTicket;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client {
    private static final Logger log = LoggerFactory.getLogger(Client.class);
    private static ClientConfig config = null;
    private String endpoint;
    private WebTarget rootTarget;

    static {
        log.debug("Creating configuration ..");
        config = new ClientConfig();
        config.register(AuthorizationFilter.class);
        config.register(JAXBElement.class);
    }

    public Client(String endpoint) {
        log.debug("Creating client for base " + endpoint);
        this.endpoint = String.valueOf(endpoint);
        this.rootTarget = ClientBuilder.newClient((Configuration)config).target(endpoint).path("/data-transfer-service/").path("/gcube/service/");
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public TransferCapabilities getCapabilties() {
        log.debug("Getting capabilities to {} ", (Object)this.endpoint);
        return (TransferCapabilities)this.rootTarget.path("Capabilities").request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(TransferCapabilities.class);
    }

    public TransferTicket submit(TransferRequest request) {
        log.debug("Sending request {} to {}", (Object)request, (Object)this.endpoint);
        return (TransferTicket)this.rootTarget.path("Requests").request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).post(Entity.entity((Object)request, (String)"application/xml"), TransferTicket.class);
    }

    public TransferTicket getTransferStatus(String transferId) {
        log.debug("Requesting transfer status [id = {}, endpoint={}]", (Object)transferId, (Object)this.endpoint);
        return (TransferTicket)this.rootTarget.path("TransferStatus").path(transferId).request(new String[]{"application/xml"}).get(TransferTicket.class);
    }
}

