/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.library;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.gcube.data.transfer.library.TransferResult;
import org.gcube.data.transfer.library.faults.FailedTransferException;
import org.gcube.data.transfer.library.faults.HostingNodeNotFoundException;
import org.gcube.data.transfer.library.faults.InitializationException;
import org.gcube.data.transfer.library.faults.InvalidSourceException;
import org.gcube.data.transfer.library.faults.ServiceNotFoundException;
import org.gcube.data.transfer.library.faults.SourceNotSetException;
import org.gcube.data.transfer.library.faults.UnreachableNodeException;
import org.gcube.data.transfer.library.transferers.Transferer;
import org.gcube.data.transfer.library.transferers.TransfererBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTransferClient {
    private static final Logger log = LoggerFactory.getLogger(DataTransferClient.class);
    private Transferer transferer = null;

    private DataTransferClient(Transferer transferer) {
        this.transferer = transferer;
    }

    public static DataTransferClient getInstanceByEndpoint(String endpoint) throws UnreachableNodeException, ServiceNotFoundException {
        log.debug("Getting transferer for endpoint : " + endpoint);
        return new DataTransferClient(TransfererBuilder.getTransfererByHost(endpoint));
    }

    public static DataTransferClient getInstanceByNodeId(String id) throws HostingNodeNotFoundException, UnreachableNodeException, ServiceNotFoundException {
        log.debug("Getting transferer for nodeId : " + id);
        return new DataTransferClient(TransfererBuilder.getTransfererByhostingNodeId(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferResult localFile(String path) throws InvalidSourceException, SourceNotSetException, FailedTransferException, InitializationException {
        Transferer transferer = this.transferer;
        synchronized (transferer) {
            if (this.transferer == null) {
                throw new RuntimeException("Transferer not set, please set destination before trying to transfer");
            }
            log.debug("Sending local file {} to {}", (Object)path, (Object)this.transferer.getDestinationCapabilities().getHostName());
            this.transferer.localFile(path);
            return this.transferer.transfer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferResult localFile(File file) throws InvalidSourceException, SourceNotSetException, FailedTransferException, InitializationException {
        Transferer transferer = this.transferer;
        synchronized (transferer) {
            if (this.transferer == null) {
                throw new RuntimeException("Transferer not set, please set destination before trying to transfer");
            }
            log.debug("Sending local file {} to {}", (Object)file.getAbsolutePath(), (Object)this.transferer.getDestinationCapabilities().getHostName());
            this.transferer.localFile(file);
            return this.transferer.transfer();
        }
    }

    public TransferResult httpSource(String url) throws InvalidSourceException, SourceNotSetException, FailedTransferException, InitializationException {
        Transferer transferer = this.transferer;
        synchronized (transferer) {
            if (this.transferer == null) {
                throw new RuntimeException("Transferer not set, please set destination before trying to transfer");
            }
            log.debug("Passed url string : " + url);
            try {
                return this.httpSource(new URL(url));
            }
            catch (MalformedURLException e) {
                throw new InvalidSourceException("Invalid url : " + url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferResult httpSource(URL url) throws InvalidSourceException, SourceNotSetException, FailedTransferException, InitializationException {
        Transferer transferer = this.transferer;
        synchronized (transferer) {
            if (this.transferer == null) {
                throw new RuntimeException("Transferer not set, please set destination before trying to transfer");
            }
            log.debug("Sending from url {} to {}", (Object)url, (Object)this.transferer.getDestinationCapabilities().getHostName());
            this.transferer.fromURL(url);
            return this.transferer.transfer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferResult storageId(String id) throws InvalidSourceException, SourceNotSetException, FailedTransferException, InitializationException {
        Transferer transferer = this.transferer;
        synchronized (transferer) {
            if (this.transferer == null) {
                throw new RuntimeException("Transferer not set, please set destination before trying to transfer");
            }
            log.debug("Sending from storage id {} to {}", (Object)id, (Object)this.transferer.getDestinationCapabilities().getHostName());
            this.transferer.storageFileId(id);
            return this.transferer.transfer();
        }
    }
}

