/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.grs;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.util.concurrent.TimeUnit;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.common.grs.FileOutcomeRecord;
import org.gcube.datatransfer.common.grs.TreeOutcomeRecord;

public class GRSOutComeWriter {
    GCUBELog logger = new GCUBELog(this.getClass());
    public boolean isItForTrees;
    public RecordWriter<GenericRecord> writer = null;

    public GRSOutComeWriter(int capacity, boolean isItForTrees) throws GRS2WriterException {
        if (isItForTrees) {
            this.isItForTrees = true;
            this.writer = new RecordWriter((IWriterProxy)new TCPWriterProxy(), TreeOutcomeRecord.treeOutcomeRecordDef, capacity, 2, 0.5f);
        } else {
            this.isItForTrees = false;
            this.writer = new RecordWriter((IWriterProxy)new TCPWriterProxy(), FileOutcomeRecord.fileOutcomeRecordDef, capacity, 2, 0.5f);
        }
    }

    public void putField(String sourceUrl, String outURL, Long transferTime, Long transferredBytes, Long total_size, Exception ... e) throws GRS2WriterException {
        if (this.isItForTrees) {
            this.logger.debug((Object)"Wrong put field method: This outcome is for trees");
            return;
        }
        this.logger.debug((Object)("Writing Outcome for url: " + sourceUrl));
        if (this.writer.getStatus() != IBuffer.Status.Open) {
            return;
        }
        GenericRecord recWriter = new GenericRecord();
        recWriter.setFields(new Field[]{new StringField(sourceUrl.toString()), e.length != 0 ? new StringField(FileOutcomeRecord.Outcome.N_A.name()) : new StringField(outURL), e.length != 0 ? new StringField(FileOutcomeRecord.Outcome.ERROR.name()) : new StringField(FileOutcomeRecord.Outcome.DONE.name()), new StringField(transferTime.toString()), new StringField(transferredBytes.toString()), new StringField(total_size.toString()), e.length != 0 ? new StringField(e[0].getMessage()) : new StringField(FileOutcomeRecord.Outcome.N_A.name())});
        if (!this.writer.put((Record)recWriter, 60L, TimeUnit.SECONDS)) {
            return;
        }
        this.logger.debug((Object)("Succesfully written Outcome for url: " + sourceUrl));
    }

    public void putField(String sourceID, String destID, int readTrees, int writtenTrees, String outcome, Exception ... e) throws GRS2WriterException {
        if (!this.isItForTrees) {
            this.logger.debug((Object)"Wrong put field method: This outcome is not for trees");
            return;
        }
        this.logger.debug((Object)("Writing Outcome for sourceID: " + sourceID));
        if (this.writer.getStatus() != IBuffer.Status.Open) {
            return;
        }
        GenericRecord recWriter = new GenericRecord();
        recWriter.setFields(new Field[]{new StringField(sourceID), new StringField(destID), new StringField(Integer.toString(readTrees)), new StringField(Integer.toString(writtenTrees)), new StringField(outcome), e.length != 0 ? new StringField(e[0].getMessage()) : new StringField(FileOutcomeRecord.Outcome.N_A.name())});
        if (!this.writer.put((Record)recWriter, 60L, TimeUnit.SECONDS)) {
            return;
        }
        this.logger.debug((Object)("Succesfully written Outcome for sourceID: " + sourceID));
    }

    public RecordWriter<GenericRecord> getWriter() {
        return this.writer;
    }

    public void setWriter(RecordWriter<GenericRecord> writer) {
        this.writer = writer;
    }

    public void close() throws GRS2WriterException {
        this.writer.close();
    }
}

