/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.handlers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.provider.DecryptSmpUrl;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.datatransfer.agent.impl.handlers.TransferHandler;
import org.gcube.datatransfer.agent.impl.jdo.TransferObject;
import org.gcube.datatransfer.agent.impl.utils.TransferUtils;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;
import org.gcube.datatransfer.common.outcome.TransferStatus;

public class StorageManagerAsyncHandlerOld
extends TransferHandler {
    IClient client = null;

    public StorageManagerAsyncHandlerOld(String[] inputFiles, String outPath, String transferId, TransferType type, IClient client, DestData data, int startIndex, int endIndex) {
        this.inputFiles = inputFiles;
        this.timeout = data.getOutUri().getOptions().getTransferTimeout();
        this.outPath = outPath;
        this.transferId = transferId;
        this.transferType = type;
        this.destData = data;
        this.client = client;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        for (int i = this.startIndex; i <= this.endIndex; ++i) {
            long startTime = 0L;
            File tmpFile = null;
            TransferObject transferObj = null;
            InputStream streamIn = null;
            FileOutputStream streamOut = null;
            try {
                String outputFile;
                transferObj = TransferUtils.createTransferObjectJDO(this.transferId, this.transferType);
                transferObj.setSourceURI(this.inputFiles[i]);
                FileObject inputFile = TransferUtils.prepareFileObject(this.inputFiles[i]);
                this.logger.debug((Object)("inputFile.getURL()= " + inputFile.getURL()));
                URLConnection connection = inputFile.getURL().openConnection();
                connection.setConnectTimeout((int)this.timeout);
                streamIn = connection.getInputStream();
                try {
                    tmpFile = new File("/tmp/data-transfer-tmp");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    throw e1;
                }
                streamOut = null;
                try {
                    streamOut = new FileOutputStream(tmpFile);
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                if (inputFile.getURL().toString().startsWith("smp")) {
                    String str = this.inputFiles[i];
                    String[] parts = str.split("\\?");
                    if (streamIn == null) {
                        String rpath = parts[0].replaceFirst("smp:/", "");
                        this.logger.debug((Object)("rpath=" + rpath));
                        DecryptSmpUrl.decrypt((String)parts[1]);
                        GCUBEScope scope = GCUBEScope.getScope((String)DecryptSmpUrl.scopeType);
                        ScopeProvider.instance.set(scope.toString());
                        IClient clientNew = new StorageClient(DecryptSmpUrl.serviceClass, DecryptSmpUrl.serviceName, DecryptSmpUrl.owner, AccessType.valueOf((String)DecryptSmpUrl.accessType.toUpperCase())).getClient();
                        streamIn = clientNew.get().RFileAsInputStream(rpath);
                    }
                    String[] partsOfMain = parts[0].split("/");
                    outputFile = partsOfMain[partsOfMain.length - 1];
                } else {
                    outputFile = inputFile.getName().getBaseName();
                }
                if (this.outPath.endsWith("/")) {
                    this.outPath = this.outPath.substring(0, this.outPath.length() - 1);
                }
                String absoluteOutputFile = this.outPath + File.separator + outputFile;
                startTime = System.currentTimeMillis();
                if (streamIn == null) {
                    this.logger.debug((Object)"streamIn=null");
                }
                if (streamOut == null) {
                    this.logger.debug((Object)"streamOut=null");
                }
                IOUtils.copy((InputStream)streamIn, (OutputStream)streamOut);
                this.client.put(true).LFile(tmpFile.getAbsolutePath()).RFile(absoluteOutputFile);
                String outURL = this.client.getUrl().RFile(absoluteOutputFile);
                this.logger.debug((Object)("localFile size=" + tmpFile.length()));
                transferObj.setDestURI(outURL);
                transferObj.setSize(tmpFile.getTotalSpace());
                transferObj.setStatus(TransferStatus.DONE.name());
                transferObj.setOutcome("File succesfully copied to " + outURL);
                this.logger.debug((Object)("File succesfully copied to " + outURL));
                streamIn.close();
                streamOut.close();
                continue;
            }
            catch (Exception e) {
                transferObj.setStatus(TransferStatus.FAILED.name());
                transferObj.setOutcome(e.toString());
                e.printStackTrace();
                this.errorHappened = true;
                continue;
            }
            finally {
                long endTime = System.currentTimeMillis();
                transferObj.setTransferTime(endTime - startTime);
                this.transferObjs.add(transferObj);
            }
        }
    }
}

