/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.event;

import com.thoughtworks.xstream.XStream;
import java.net.URI;
import java.util.concurrent.FutureTask;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.trees.patterns.Pattern;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.db.DataTransferDBManager;
import org.gcube.datatransfer.agent.impl.event.AgentFunctions;
import org.gcube.datatransfer.agent.impl.utils.Utils;
import org.gcube.datatransfer.agent.impl.worker.Worker;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.InputPattern;
import org.gcube.datatransfer.agent.stubs.datatransferagent.OutUriData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.SourceData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.StorageType;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferFault;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;
import org.gcube.datatransfer.common.messaging.MessageChecker;
import org.gcube.datatransfer.common.messaging.messages.TransferRequestMessage;

public class TransferRequestChecker
extends MessageChecker<TransferRequestMessage> {
    public GCUBELog logger = new GCUBELog(TransferRequestChecker.class);
    private static DataTransferDBManager dbManager = ServiceContext.getContext().getDbManager();

    public TransferRequestChecker(GCUBEScope scope, String subscriberEndpoint) {
        super(scope, subscriberEndpoint);
    }

    public void check(TransferRequestMessage message) {
        String destEndpoint = message.getDestEndpoint();
        if (destEndpoint == null) {
            return;
        }
        if (destEndpoint.compareTo(this.subscriberEndpoint) == 0) {
            this.handleMessage(message);
        }
    }

    public void handleMessage(TransferRequestMessage message) {
        this.logger.debug((Object)("TransferRequestChecker - Start Transfer invoked in scope " + message.getScope()));
        String id = message.getTransferId();
        AgentFunctions agentFunctions = new AgentFunctions();
        try {
            DestData destData;
            SourceData sourceData;
            this.logger.debug((Object)("treesource=" + message.getTreeSourceID() + " -- destId=" + message.getTreeDestID() + " -- pattern=" + message.getTreePattern()));
            if (message.getTreeSourceID() == null) {
                sourceData = new SourceData();
                String[] arrayUris = new String[message.getInputUris().size()];
                for (int i = 0; i < arrayUris.length; ++i) {
                    arrayUris[i] = ((URI)message.getInputUris().get(i)).toString();
                }
                sourceData.setInputURIs(arrayUris);
                sourceData.setScope(message.getScope());
                sourceData.setType(TransferType.FileBasedTransfer);
                destData = new DestData();
                destData.setScope(message.getScope());
                destData.setType(TransferType.FileBasedTransfer.getValue());
                OutUriData outUri = new OutUriData();
                outUri.setOptions(AgentFunctions.getMappedTransferOptions(message.getTransferOptions()));
                if (outUri.getOptions().getStorageType().equals((Object)StorageType.DataStorage)) {
                    String[] arrayOutputUris = new String[message.getOutputUris().size()];
                    for (int i = 0; i < arrayOutputUris.length; ++i) {
                        arrayOutputUris[i] = ((URI)message.getOutputUris().get(i)).toString();
                    }
                    outUri.setOutUris(arrayOutputUris);
                } else {
                    String outputFolder = message.getDestination();
                    if (outputFolder.startsWith("/")) {
                        outputFolder = outputFolder.substring(1);
                    }
                    outUri.setOutUris(new String[]{outputFolder});
                }
                destData.setOutUri(outUri);
            } else {
                destData = new DestData();
                destData.setOutSourceId(message.getTreeDestID());
                destData.setScope(ScopeProvider.instance.get());
                sourceData = new SourceData();
                InputPattern input = new InputPattern();
                XStream xstreamForPattern = new XStream();
                Pattern patternInput = (Pattern)xstreamForPattern.fromXML(message.getTreePattern());
                try {
                    input.setPattern(Utils.toHolder(patternInput));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                input.setSourceId(message.getTreeSourceID());
                sourceData.setInputSource(input);
                sourceData.setScope(ScopeProvider.instance.get());
                sourceData.setType(TransferType.TreeBasedTransfer);
            }
            FutureTask<Worker> task = agentFunctions.startAsyncTask(id, sourceData, destData);
        }
        catch (Exception e) {
            this.logger.error((Object)"TransferRequestChecker - Unable to perform the transfer", (Throwable)e);
            try {
                throw (TransferFault)org.gcube.datatransfer.common.utils.Utils.newFault((GCUBEFault)new TransferFault(), (Throwable)e);
            }
            catch (TransferFault e1) {
                e1.printStackTrace();
                return;
            }
        }
        this.logger.info((Object)("TransferRequestChecker - transfer id : " + id + " - submitterEndpoint : " + message.getSourceEndpoint()));
        try {
            dbManager.updateTransferSubmitterEndpoint(id, message.getSourceEndpoint());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)"exception when call dbManager.updateTransferSubmitterEndpoint ... ");
        }
        try {
            dbManager.updateLastNotificationMsgSent(id, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)"exception when call dbManager.updateLastNotificationMsgSent ... ");
        }
    }
}

