/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.db.DBManager;
import org.gcube.datatransfer.agent.impl.grs.GRSOutComeWriter;
import org.gcube.datatransfer.agent.impl.jdo.Transfer;
import org.gcube.datatransfer.agent.impl.jdo.TransferObject;
import org.gcube.datatransfer.agent.stubs.datatransferagent.MonitorTransferReportMessage;
import org.gcube.datatransfer.common.agent.Types;
import org.gcube.datatransfer.common.grs.FileOutcomeRecord;
import org.gcube.datatransfer.common.outcome.FileTransferOutcome;
import org.gcube.datatransfer.common.outcome.TransferStatus;
import org.gcube.datatransfer.common.outcome.TreeTransferOutcome;

public class DataTransferDBManager
extends DBManager
implements Runnable {
    GCUBELog logger = new GCUBELog(DataTransferDBManager.class);

    public DataTransferDBManager() throws Exception {
        this.dbFileBaseFolder = ServiceContext.getContext().getPersistenceRoot().getAbsolutePath() + File.separator + "DataTransferDB";
        this.dbName = "data_transfer";
        this.dbFileName = this.dbFileBaseFolder + File.separator + this.dbName + ".db";
        backupFolder = new File(System.getenv("HOME") + File.separator + "DataTransferDBBackup");
        Properties prop = new Properties();
        String propFile = GHNContext.getContext().getLocation() + File.separator + ServiceContext.getContext().getProperty("configDir", new boolean[]{true}) + File.separator + ServiceContext.getContext().getDbConfigurationFileName();
        try {
            prop.load(new FileInputStream(new File(propFile)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.persistenceFactory = JDOHelper.getPersistenceManagerFactory((Map)prop);
        Thread t = new Thread(this);
        t.start();
    }

    public boolean checkIfTransferExist(String id) throws Exception {
        try {
            PersistenceManager persistenceManager = this.getPersistenceManager();
            Query query = persistenceManager.newQuery(Transfer.class);
            query.setFilter("id == \"" + id + "\"");
            List list = (List)query.execute();
            return list != null && list.size() != 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void storeTransfer(Transfer transfer) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            persistenceManager.currentTransaction().begin();
            persistenceManager.makePersistent((Object)transfer);
            persistenceManager.currentTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateTransfer(String id) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)id);
            t.setStatus(TransferStatus.QUEUED.name());
            t.setSubmitter("N/A");
            t.setTransfersCompleted(0L);
            t.setTotalSize(0L);
            t.setSizeTransferred(0L);
            t.setTotalTransfers(0L);
            persistenceManager.makePersistent((Object)t);
            persistenceManager.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void storeTransferObject(Set<TransferObject> transferObjects) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        try {
            for (TransferObject obj : transferObjects) {
                persistenceManager.currentTransaction().begin();
                persistenceManager.makePersistent((Object)obj);
                persistenceManager.currentTransaction().commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (persistenceManager.currentTransaction().isActive()) {
                persistenceManager.currentTransaction().rollback();
            }
            persistenceManager.close();
        }
    }

    public void updateTransferSubmitterEndpoint(String transferId, String submitterEndpoint) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
        t.setSubmitterEndpoint(submitterEndpoint);
        persistenceManager.makePersistent((Object)t);
        persistenceManager.close();
    }

    public void updateLastNotificationMsgSent(String transferId, boolean value) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
        t.setLastNotificationMsgSent(value);
        persistenceManager.makePersistent((Object)t);
        persistenceManager.close();
    }

    public String getTransferStatus(String transferId) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
        persistenceManager.close();
        return t.getStatus();
    }

    public void updateTransferObjectStatus(String objId, String status) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)objId);
        this.logger.debug((Object)("Old status " + t.getStatus()));
        t.setStatus(status);
        this.logger.debug((Object)("New Status " + t.getStatus()));
        persistenceManager.makePersistent((Object)t);
        persistenceManager.close();
    }

    public void updateReadTreesInTransfer(String transferId, int val) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
        t.setTotalReadTrees(val);
        persistenceManager.makePersistent((Object)t);
        persistenceManager.close();
    }

    public void updateWrittenTreesInTransfer(String transferId, int val) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
        t.setTotalWrittenTrees(val);
        persistenceManager.makePersistent((Object)t);
        persistenceManager.close();
    }

    public void updateTransferObjectInfo(String objId, long size) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)objId);
        t.setSizeTransferred(t.getSizeTransferred() + size);
        persistenceManager.makePersistent((Object)t);
        persistenceManager.close();
    }

    public void addTransferObjectCompleted(String objId) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)objId);
        this.logger.debug((Object)("Old completed" + t.getTransfersCompleted()));
        t.setTransfersCompleted(t.getTransfersCompleted() + 1L);
        this.logger.debug((Object)("New completed" + t.getTransfersCompleted()));
        persistenceManager.makePersistent((Object)t);
        persistenceManager.close();
    }

    public void updateTransferJDO(String transferId, String[] inputURIs, long totalsize) throws Exception {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
        t.setId(transferId);
        t.setStatus(TransferStatus.STARTED.name());
        t.setSubmitter("N/A");
        t.setTransfersCompleted(0L);
        t.setTotalSize(totalsize);
        t.setTransfersCompleted(0L);
        t.setTotalTransfers(inputURIs.length);
        persistenceManager.makePersistent((Object)t);
        persistenceManager.close();
    }

    @Override
    public void run() {
        do {
            try {
                Thread.sleep(backupIntervalMS);
                this.backup();
            }
            catch (InterruptedException e) {
                this.logger.error((Object)"Unable to sleep", (Throwable)e);
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to backup", (Throwable)e);
            }
        } while (!Thread.interrupted());
    }

    public PersistenceManager getPersistenceManager() {
        return this.persistenceFactory.getPersistenceManager();
    }

    public String getTransferObjectOutComeAsRS(String transferId) throws Exception {
        GRSOutComeWriter outcomeWriter = null;
        PersistenceManager persistenceManager = this.getPersistenceManager();
        if (!this.checkIfTransferExist(transferId)) {
            this.logger.debug((Object)("getTransferObjectOutComeAsRS - transfer with id=" + transferId + " does not exist"));
            return null;
        }
        Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
        boolean isItForTrees = false;
        if (t.getSourceID() != null && t.getDestID() != null) {
            isItForTrees = true;
        }
        if (!TransferStatus.valueOf((String)t.getStatus()).hasCompleted()) {
            if (isItForTrees) {
                outcomeWriter = new GRSOutComeWriter(1, true);
                outcomeWriter.putField(transferId, "", new Long(0L), new Long(0L), new Long(0L), new Exception("The submitted transfer is not yet completed"));
            } else {
                outcomeWriter = new GRSOutComeWriter(1, false);
                outcomeWriter.putField(transferId, "", 0, 0, "", new Exception("The submitted transfer is not yet completed"));
            }
        } else if (isItForTrees) {
            outcomeWriter = new GRSOutComeWriter(1, true);
            if (t.getStatus().compareTo(TransferStatus.FAILED.name()) == 0) {
                outcomeWriter.putField(t.getSourceID(), t.getDestID(), t.getTotalReadTrees(), t.getTotalWrittenTrees(), t.getStatus(), new Exception(t.getStatus()));
            } else {
                outcomeWriter.putField(t.getSourceID(), t.getDestID(), t.getTotalReadTrees(), t.getTotalWrittenTrees(), t.getStatus(), new Exception[0]);
            }
        } else {
            Query query = persistenceManager.newQuery(TransferObject.class);
            query.setFilter("transferID == \"" + transferId + "\"");
            List list = (List)query.execute();
            if (list == null || list.size() == 0) {
                throw new Exception("The Transfer Objects list is empty");
            }
            this.logger.debug((Object)("Getting " + list.size() + " outcomes"));
            outcomeWriter = new GRSOutComeWriter(list.size(), false);
            for (TransferObject obj : list) {
                long bytesThatHaveBeenTransferred = 0L;
                if (obj.getBytesOfObjTransferred() == null && obj.getSize() != null) {
                    bytesThatHaveBeenTransferred = obj.getSize();
                } else if (obj.getBytesOfObjTransferred() != null) {
                    bytesThatHaveBeenTransferred = obj.getBytesOfObjTransferred();
                }
                long total_size = 0L;
                if (obj.getSize() != null) {
                    total_size = obj.getSize();
                }
                if (obj.getStatus().compareTo(TransferStatus.FAILED.name()) == 0) {
                    outcomeWriter.putField(obj.getSourceURI(), obj.getDestURI(), obj.getTransferTime(), bytesThatHaveBeenTransferred, total_size, new Exception(obj.getOutcome()));
                } else {
                    outcomeWriter.putField(obj.getSourceURI(), obj.getDestURI(), obj.getTransferTime(), bytesThatHaveBeenTransferred, total_size, new Exception[0]);
                }
                persistenceManager.deletePersistent((Object)obj);
            }
        }
        persistenceManager.close();
        return outcomeWriter.writer.getLocator().toString();
    }

    public ArrayList<FileTransferOutcome> getTransferObjectOutCome(String transferId) throws Exception {
        ArrayList<FileTransferOutcome> outcomes = new ArrayList<FileTransferOutcome>();
        PersistenceManager persistenceManager = this.getPersistenceManager();
        if (!this.checkIfTransferExist(transferId)) {
            this.logger.debug((Object)("getTransferObjectOutCome - transfer with id=" + transferId + " does not exist"));
            return null;
        }
        Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
        if (!TransferStatus.valueOf((String)t.getStatus()).hasCompleted()) {
            return null;
        }
        Query query = persistenceManager.newQuery(TransferObject.class);
        query.setFilter("transferID == \"" + transferId + "\"");
        List list = (List)query.execute();
        if (list == null || list.size() == 0) {
            throw new Exception("The Transfer Objects list is empty");
        }
        this.logger.debug((Object)("Getting " + list.size() + " outcomes"));
        for (TransferObject obj : list) {
            long bytesThatHaveBeenTransferred = 0L;
            if (obj.getBytesOfObjTransferred() == null && obj.getSize() != null) {
                bytesThatHaveBeenTransferred = obj.getSize();
            } else if (obj.getBytesOfObjTransferred() != null) {
                bytesThatHaveBeenTransferred = obj.getBytesOfObjTransferred();
            }
            String sourceUri = obj.getSourceURI();
            String destUri = obj.getDestURI();
            String outcomeField = FileOutcomeRecord.Outcome.DONE.name();
            String exception = FileOutcomeRecord.Outcome.N_A.name();
            long transferTime = 0L;
            if (obj.getTransferTime() != null) {
                transferTime = obj.getTransferTime();
            }
            if (obj.getStatus().compareTo(TransferStatus.FAILED.name()) == 0) {
                destUri = FileOutcomeRecord.Outcome.N_A.name();
                outcomeField = FileOutcomeRecord.Outcome.ERROR.name();
                exception = obj.getOutcome();
            }
            this.logger.trace((Object)("FileName :" + sourceUri));
            this.logger.trace((Object)("dest :" + destUri));
            this.logger.trace((Object)("Outcome :" + outcomeField));
            this.logger.trace((Object)("Transfer Time: " + transferTime));
            this.logger.trace((Object)("Transferred Bytes: " + bytesThatHaveBeenTransferred));
            this.logger.trace((Object)("Exception: " + exception));
            FileTransferOutcome outcome = new FileTransferOutcome(sourceUri);
            outcome.setException(exception);
            outcome.setDest(destUri);
            outcome.setTransferTime(Long.valueOf(transferTime));
            outcome.setTransferredBytes(Long.valueOf(bytesThatHaveBeenTransferred));
            long total_size = 0L;
            if (obj.getSize() != null) {
                total_size = obj.getSize();
            }
            outcome.setTotal_size(Long.valueOf(total_size));
            outcomes.add(outcome);
            persistenceManager.deletePersistent((Object)obj);
        }
        persistenceManager.close();
        return outcomes;
    }

    public TreeTransferOutcome getTransferTreeOutCome(String transferId) throws Exception {
        TreeTransferOutcome outcome = new TreeTransferOutcome();
        PersistenceManager persistenceManager = this.getPersistenceManager();
        if (!this.checkIfTransferExist(transferId)) {
            this.logger.debug((Object)("getTransferTreeOutCome - transfer with id=" + transferId + " does not exist"));
            return null;
        }
        Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
        if (t == null) {
            return null;
        }
        if (!TransferStatus.valueOf((String)t.getStatus()).hasCompleted()) {
            return null;
        }
        outcome.setSourceID(t.getSourceID());
        outcome.setDestID(t.getDestID());
        outcome.setTotalReadTrees(t.getTotalReadTrees());
        outcome.setTotalWrittenTrees(t.getTotalWrittenTrees());
        if (t.getStatus().compareTo(TransferStatus.FAILED.name()) == 0) {
            outcome.setException(t.getStatus());
        } else {
            outcome.setException("N_A");
        }
        return outcome;
    }

    public MonitorTransferReportMessage getTrasferProgress(String transferId) {
        MonitorTransferReportMessage message = new MonitorTransferReportMessage();
        PersistenceManager persistenceManager = this.getPersistenceManager();
        Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
        message.setTransferID(transferId);
        message.setTotalBytes(t.getTotalSize());
        message.setTotalTransfers((int)t.getTotaltransfers());
        message.setTransferCompleted((int)t.getTransfersCompleted());
        message.setBytesTransferred(t.getSizeTransferred());
        message.setTransferStatus(t.getStatus());
        persistenceManager.close();
        return message;
    }

    public Types.MonitorTransferReportMessage getTrasferProgressType(String transferId) {
        Types.MonitorTransferReportMessage message = new Types.MonitorTransferReportMessage();
        PersistenceManager persistenceManager = this.getPersistenceManager();
        Transfer t = (Transfer)persistenceManager.getObjectById(Transfer.class, (Object)transferId);
        message.setTransferID(transferId);
        message.setTotalBytes(t.getTotalSize());
        message.setTotalTransfers((int)t.getTotaltransfers());
        message.setTransferCompleted((int)t.getTransfersCompleted());
        message.setBytesTransferred(t.getSizeTransferred());
        message.setTransferStatus(t.getStatus());
        persistenceManager.close();
        return message;
    }
}

