/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.streams;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.events.GCUBEEvent;
import org.gcube.common.core.utils.events.GCUBETopic;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.streams.delegates.StreamListenerAdapter;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.event.Events;
import org.gcube.datatransfer.agent.impl.event.TransferOutcome;
import org.gcube.datatransfer.agent.impl.streams.Counter;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.SourceData;
import org.gcube.datatransfer.common.outcome.TransferStatus;

public class StreamCopyListenerOnRead
extends StreamListenerAdapter {
    protected GCUBELog logger = new GCUBELog(((Object)((Object)this)).getClass());
    SourceData sourceParameters;
    DestData destParameters;
    String transferId;
    Counter readTreesCounter;
    GCUBEEvent<Events.TransferTopics, TransferOutcome> event = null;

    public StreamCopyListenerOnRead(String transferID, SourceData source, DestData dest, Counter readTreesCounter) {
        this.transferId = transferID;
        this.sourceParameters = source;
        this.destParameters = dest;
        this.readTreesCounter = readTreesCounter;
    }

    public void onEnd() {
        this.sendEvent(Events.TransferTopics.TRANSFER_END, "Transfer Completed");
    }

    public void onStart() {
        this.sendEvent(Events.TransferTopics.TRANSFER_START, "Transfer Started");
    }

    public void sendEvent(Events.TransferTopics topic, String message) {
        try {
            if (topic == null) {
                this.logger.error((Object)"transfer topic == null");
            } else {
                this.logger.debug((Object)("transfer topic = " + topic.name() + " -  read trees = " + this.readTreesCounter.total));
                int readTrees = this.readTreesCounter.total;
                if (topic.equals((Object)Events.TransferTopics.TRANSFER_START)) {
                    ServiceContext.getContext().getDbManager().updateTransferObjectStatus(this.transferId, TransferStatus.STARTED.toString());
                } else if (topic.equals((Object)Events.TransferTopics.TRANSFER_FAIL)) {
                    ServiceContext.getContext().getDbManager().updateReadTreesInTransfer(this.transferId, readTrees);
                    this.logger.debug((Object)("total read trees = " + readTrees));
                } else if (topic.equals((Object)Events.TransferTopics.TRANSFER_CANCEL)) {
                    ServiceContext.getContext().getDbManager().updateReadTreesInTransfer(this.transferId, readTrees);
                    this.logger.debug((Object)("total read trees = " + readTrees));
                } else if (topic.equals((Object)Events.TransferTopics.TRANSFER_END)) {
                    ServiceContext.getContext().getDbManager().updateReadTreesInTransfer(this.transferId, readTrees);
                    this.logger.debug((Object)("total read trees = " + readTrees));
                }
            }
            this.event = new GCUBEEvent();
            TransferOutcome outcome = new TransferOutcome();
            outcome.setTransferId(this.transferId);
            outcome.setDestID(this.destParameters.getOutSourceId());
            outcome.setOutcome(message);
            outcome.setScope(GCUBEScope.getScope((String)this.destParameters.getScope()));
            outcome.setSourceID(this.sourceParameters.getInputSource().getSourceId());
            outcome.setTransferPhase(topic.name());
            outcome.setTransferType(this.sourceParameters.getType());
            this.event.setPayload((Object)outcome);
            ServiceContext.transferEventproducer.notify((GCUBETopic)topic, new GCUBEEvent[]{this.event});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

