/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.streams;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.streams.delegates.StreamListenerAdapter;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.event.Events;
import org.gcube.datatransfer.agent.impl.streams.Counter;
import org.gcube.datatransfer.common.outcome.TransferStatus;

public class StreamCopyListenerOnWrite
extends StreamListenerAdapter {
    protected GCUBELog logger = new GCUBELog(((Object)((Object)this)).getClass());
    Counter writtenTreesCounter;
    String transferId;

    public StreamCopyListenerOnWrite(String transferId, Counter writtenTreesCounter) {
        this.writtenTreesCounter = writtenTreesCounter;
        this.transferId = transferId;
    }

    public void onEnd() {
        this.sendEvent(Events.TransferTopics.TRANSFER_END, "Transfer Completed");
    }

    public void onStart() {
        this.sendEvent(Events.TransferTopics.TRANSFER_START, "Transfer Started");
    }

    public void sendEvent(Events.TransferTopics topic, String message) {
        try {
            int writtenTrees = this.writtenTreesCounter.total;
            if (topic == null) {
                this.logger.error((Object)"transfer topic == null");
            } else if (topic.equals((Object)Events.TransferTopics.TRANSFER_FAIL)) {
                ServiceContext.getContext().getDbManager().updateWrittenTreesInTransfer(this.transferId, writtenTrees);
                this.logger.debug((Object)("total written trees = " + writtenTrees));
                ServiceContext.getContext().getDbManager().updateTransferObjectStatus(this.transferId, TransferStatus.FAILED.toString());
            } else if (topic.equals((Object)Events.TransferTopics.TRANSFER_CANCEL)) {
                ServiceContext.getContext().getDbManager().updateWrittenTreesInTransfer(this.transferId, writtenTrees);
                this.logger.debug((Object)("total written trees = " + writtenTrees));
                ServiceContext.getContext().getDbManager().updateTransferObjectStatus(this.transferId, TransferStatus.CANCEL.toString());
            } else if (topic.equals((Object)Events.TransferTopics.TRANSFER_END)) {
                ServiceContext.getContext().getDbManager().updateWrittenTreesInTransfer(this.transferId, writtenTrees);
                this.logger.debug((Object)("total written trees = " + writtenTrees));
                ServiceContext.getContext().getDbManager().updateTransferObjectStatus(this.transferId, TransferStatus.DONE.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

