/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.event;

import java.util.List;
import javax.jdo.Query;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.event.ProduceResponse;
import org.gcube.datatransfer.agent.impl.jdo.Transfer;
import org.gcube.datatransfer.common.outcome.TransferStatus;

public class TransferDBChecker
extends Thread {
    public GCUBELog logger = new GCUBELog(TransferDBChecker.class);
    private int intervalForDBCheckInMS = ServiceContext.getContext().getIntervalForDBCheck();

    public TransferDBChecker() {
        if (this.intervalForDBCheckInMS < 1000 || this.intervalForDBCheckInMS > 120000) {
            this.logger.debug((Object)("TransferDBChecker  - replace value of intervalForDBCheckInMS to 20000ms because it was" + this.intervalForDBCheckInMS));
            this.intervalForDBCheckInMS = 20000;
        }
    }

    @Override
    public void run() {
        this.logger.debug((Object)("TransferDBChecker has been started ... (intervalForDBCheckInMS=" + this.intervalForDBCheckInMS + ")"));
        while (true) {
            Query query = ServiceContext.getContext().getDbManager().getPersistenceManager().newQuery(Transfer.class);
            List list = (List)query.execute();
            for (Transfer obj : list) {
                if (!this.checkValidity(obj.getStatus()) || obj.isLastNotificationMsgSent() || obj.getSubmitterEndpoint() == null) continue;
                this.logger.debug((Object)"TransferDBChecker -  notifying ...");
                ProduceResponse.notify(obj.getId());
            }
            this.specificTimeSleep();
        }
    }

    public void specificTimeSleep() {
        try {
            Thread.sleep(this.intervalForDBCheckInMS);
        }
        catch (InterruptedException e) {
            this.logger.error((Object)"\nTransferDBChecker (specificTimeSleep)-- InterruptedException-Unable to sleep");
            e.printStackTrace();
        }
    }

    public boolean checkValidity(String status) {
        if (status == null) {
            return false;
        }
        return status.compareTo(TransferStatus.QUEUED.toString()) == 0 || status.compareTo(TransferStatus.STARTED.toString()) == 0 || status.compareTo(TransferStatus.DONE.toString()) == 0 || status.compareTo(TransferStatus.DONE_WITH_ERRORS.toString()) == 0 || status.compareTo(TransferStatus.CANCEL.toString()) == 0 || status.compareTo(TransferStatus.FAILED.toString()) == 0;
    }
}

