/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.event;

import java.net.URI;
import java.util.concurrent.FutureTask;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.db.DataTransferDBManager;
import org.gcube.datatransfer.agent.impl.event.AgentFunctions;
import org.gcube.datatransfer.agent.impl.worker.Worker;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.OutUriData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.SourceData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.StorageType;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferFault;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;
import org.gcube.datatransfer.common.messaging.MessageChecker;
import org.gcube.datatransfer.common.messaging.messages.TransferRequestMessage;
import org.gcube.datatransfer.common.utils.Utils;

public class TransferRequestChecker
extends MessageChecker<TransferRequestMessage> {
    public GCUBELog logger = new GCUBELog(TransferRequestChecker.class);
    private static DataTransferDBManager dbManager = ServiceContext.getContext().getDbManager();

    public TransferRequestChecker(GCUBEScope scope, String subscriberEndpoint) {
        super(scope, subscriberEndpoint);
    }

    public void check(TransferRequestMessage message) {
        String destEndpoint = message.getDestEndpoint();
        if (destEndpoint == null) {
            return;
        }
        if (destEndpoint.compareTo(this.subscriberEndpoint) == 0) {
            this.handleMessage(message);
        }
    }

    public void handleMessage(TransferRequestMessage message) {
        this.logger.debug((Object)("TransferRequestChecker - Start Transfer invoked in scope " + message.getScope()));
        String id = message.getTransferId();
        AgentFunctions agentFunctions = new AgentFunctions();
        try {
            SourceData sourceData = new SourceData();
            String[] arrayUris = new String[message.getInputUris().size()];
            for (int i = 0; i < arrayUris.length; ++i) {
                arrayUris[i] = ((URI)message.getInputUris().get(i)).toString();
            }
            sourceData.setInputURIs(arrayUris);
            sourceData.setScope(message.getScope());
            sourceData.setType(TransferType.FileBasedTransfer);
            DestData destData = new DestData();
            destData.setScope(message.getScope());
            destData.setType(TransferType.FileBasedTransfer.getValue());
            OutUriData outUri = new OutUriData();
            outUri.setOptions(AgentFunctions.getMappedTransferOptions(message.getTransferOptions()));
            if (outUri.getOptions().getStorageType().equals((Object)StorageType.DataStorage)) {
                String[] arrayOutputUris = new String[message.getOutputUris().size()];
                for (int i = 0; i < arrayOutputUris.length; ++i) {
                    arrayOutputUris[i] = ((URI)message.getOutputUris().get(i)).toString();
                }
                outUri.setOutUris(arrayOutputUris);
            } else {
                String outputFolder = message.getDestination();
                if (outputFolder.startsWith("/")) {
                    outputFolder = outputFolder.substring(1);
                }
                outUri.setOutUris(new String[]{outputFolder});
            }
            destData.setOutUri(outUri);
            FutureTask<Worker> task = agentFunctions.startAsyncTask(id, sourceData, destData);
        }
        catch (Exception e) {
            this.logger.error((Object)"TransferRequestChecker - Unable to perform the transfer", (Throwable)e);
            try {
                throw (TransferFault)Utils.newFault((GCUBEFault)new TransferFault(), (Throwable)e);
            }
            catch (TransferFault e1) {
                e1.printStackTrace();
                return;
            }
        }
        this.logger.info((Object)("TransferRequestChecker - transfer id : " + id + " - submitterEndpoint : " + message.getSourceEndpoint()));
        try {
            dbManager.updateTransferSubmitterEndpoint(id, message.getSourceEndpoint());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)"exception when call dbManager.updateTransferSubmitterEndpoint ... ");
        }
        try {
            dbManager.updateLastNotificationMsgSent(id, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)"exception when call dbManager.updateLastNotificationMsgSent ... ");
        }
    }
}

