package org.gcube.datatransfer.agent.impl.jdo;

import java.io.Serializable;

import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.PrimaryKey;

@PersistenceCapable
public class Transfer implements Serializable{
	
	private static final long serialVersionUID = 1L;
	
	@PrimaryKey
	private String id ="";
	//Can be the user DN if available or the service caller (serviceclass/servicename)
	protected String submitter;
	
	protected String submitterEndpoint; //(schedulerEndpoint) if messaging is enabled
	protected boolean lastNotificationMsgSent; //if messaging is enabled
	protected String status;
	
	protected long totalTransfers;
	
	public long getTotaltransfers() {
		return totalTransfers;
	}

	public void setTotalTransfers(long totaltransfers) {
		this.totalTransfers = totaltransfers;
	}

	public long getTransfersCompleted() {
		return transfersCompleted;
	}

	public void setTransfersCompleted(long transfersCompleted) {
		this.transfersCompleted = transfersCompleted;
	}

	public long getTotalSize() {
		return totalSize;
	}

	public void setTotalSize(long totalSize) {
		this.totalSize = totalSize;
	}

	public long getSizeTransferred() {
		return sizeTransferred;
	}

	public void setSizeTransferred(Long sizeTransferred) {
		this.sizeTransferred = sizeTransferred;
	}

	protected long transfersCompleted;
		
	protected long totalSize;
	
	protected long sizeTransferred;
	
	
	public String getId() {
		return id;
	}

	public void setId(String transferId) {
		this.id = transferId;
	}

	public String getSubmitter() {
		return submitter;
	}

	public void setSubmitter(String submitter) {
		this.submitter = submitter;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getSubmitterEndpoint() {
		return submitterEndpoint;
	}

	public void setSubmitterEndpoint(String submitterEndpoint) {
		this.submitterEndpoint = submitterEndpoint;
	}

	public boolean isLastNotificationMsgSent() {
		return lastNotificationMsgSent;
	}

	public void setLastNotificationMsgSent(boolean lastNotificationMsgSent) {
		this.lastNotificationMsgSent = lastNotificationMsgSent;
	}


	
}
