/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.handlers;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.provider.DecryptSmpUrl;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.handlers.CopyStreamHandler;
import org.gcube.datatransfer.agent.impl.handlers.TransferHandler;
import org.gcube.datatransfer.agent.impl.jdo.TransferObject;
import org.gcube.datatransfer.agent.impl.utils.TransferUtils;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;
import org.gcube.datatransfer.common.outcome.TransferStatus;

public class StorageManagerAsyncHandler
extends TransferHandler {
    IClient client = null;
    public static int bufferSize = 1024000;
    private long bytesTransferredForCurrent;
    private ExecutorService pool;
    CopyStreamListener listener = new CopyStreamListener(){

        public void bytesTransferred(long arg0, int arg1, long arg2) {
            try {
                ServiceContext.getContext().getDbManager().updateTransferObjectInfo(StorageManagerAsyncHandler.this.transferId, arg1);
                StorageManagerAsyncHandler.this.bytesTransferredForCurrent = StorageManagerAsyncHandler.this.bytesTransferredForCurrent + (long)arg1;
            }
            catch (Exception e) {
                StorageManagerAsyncHandler.this.logger.error((Object)"Error updating DB");
            }
        }

        public void bytesTransferred(CopyStreamEvent arg0) {
        }
    };

    public StorageManagerAsyncHandler(String[] inputFiles, String outPath, String transferId, TransferType type, IClient client, DestData data, int startIndex, int endIndex) {
        this.inputFiles = inputFiles;
        this.timeout = data.getOutUri().getOptions().getTransferTimeout();
        this.outPath = outPath;
        this.transferId = transferId;
        this.transferType = type;
        this.destData = data;
        this.client = client;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        for (int i = this.startIndex; i <= this.endIndex; ++i) {
            this.pool = Executors.newFixedThreadPool(1);
            long startTime = 0L;
            TransferObject transferObj = null;
            InputStream streamIn = null;
            OutputStream streamOut = null;
            try {
                String outputFile;
                transferObj = TransferUtils.createTransferObjectJDO(this.transferId, this.transferType);
                transferObj.setSourceURI(this.inputFiles[i]);
                FileObject inputFile = TransferUtils.prepareFileObject(this.inputFiles[i]);
                this.logger.debug((Object)("inputFile.getURL()= " + inputFile.getURL()));
                URLConnection connection = inputFile.getURL().openConnection();
                connection.setConnectTimeout((int)this.timeout);
                streamIn = connection.getInputStream();
                if (inputFile.getURL().toString().startsWith("smp")) {
                    String str = this.inputFiles[i];
                    String[] parts = str.split("\\?");
                    if (streamIn == null) {
                        String rpath = parts[0].replaceFirst("smp:/", "");
                        this.logger.debug((Object)("rpath=" + rpath));
                        DecryptSmpUrl.decrypt((String)parts[1]);
                        GCUBEScope scope = GCUBEScope.getScope((String)DecryptSmpUrl.scopeType);
                        ScopeProvider.instance.set(scope.toString());
                        IClient clientNew = new StorageClient(DecryptSmpUrl.serviceClass, DecryptSmpUrl.serviceName, DecryptSmpUrl.owner, AccessType.valueOf((String)DecryptSmpUrl.accessType.toUpperCase())).getClient();
                        streamIn = clientNew.get().RFileAsInputStream(rpath);
                    }
                    String[] partsOfMain = parts[0].split("/");
                    outputFile = partsOfMain[partsOfMain.length - 1];
                } else {
                    outputFile = inputFile.getName().getBaseName();
                }
                outputFile = outputFile.replaceAll(" ", "%20");
                if (this.outPath.endsWith("/")) {
                    this.outPath = this.outPath.substring(0, this.outPath.length() - 1);
                }
                String absoluteOutputFile = this.outPath + File.separator + outputFile;
                streamOut = this.client.put(true).RFileAsOutputStream(absoluteOutputFile);
                String outURL = this.client.getUrl().RFile(absoluteOutputFile);
                transferObj.setDestURI(outURL);
                if (streamIn == null) {
                    this.logger.debug((Object)"streamIn=null");
                }
                if (streamOut == null) {
                    this.logger.debug((Object)"streamOut=null");
                }
                this.logger.debug((Object)("Copy file from URL " + inputFile.getURL() + " to : " + outURL));
                startTime = System.currentTimeMillis();
                boolean terminate = false;
                OutputStream destinationFileOut = streamOut;
                InputStream sourceFileIn = streamIn;
                this.bytesTransferredForCurrent = 0L;
                CopyStreamHandler handler = new CopyStreamHandler(sourceFileIn, destinationFileOut, inputFile.getContent().getSize(), this.listener);
                try {
                    this.pool.execute(handler);
                    this.pool.shutdown();
                }
                catch (Exception e) {
                    this.pool.shutdownNow();
                    e.printStackTrace();
                    throw new Exception("Error while executing the transfer");
                }
                terminate = this.pool.awaitTermination(this.timeout, TimeUnit.MILLISECONDS);
                sourceFileIn.close();
                destinationFileOut.close();
                if (terminate) {
                    this.logger.debug((Object)("File succesfully copied to " + outURL));
                    transferObj.setSize(inputFile.getContent().getSize());
                    transferObj.setBytesOfObjTransferred(this.bytesTransferredForCurrent);
                    transferObj.setStatus(TransferStatus.DONE.name());
                    transferObj.setOutcome("File succesfully copied to " + outURL);
                    continue;
                }
                String msg = "Transfer aborted because timeout has elapsed";
                this.logger.error((Object)msg);
                throw new Exception(msg);
            }
            catch (Exception e) {
                transferObj.setStatus(TransferStatus.FAILED.name());
                transferObj.setOutcome(e.toString());
                e.printStackTrace();
                this.errorHappened = true;
                continue;
            }
            finally {
                long endTime = System.currentTimeMillis();
                transferObj.setTransferTime(endTime - startTime);
                this.transferObjs.add(transferObj);
            }
        }
    }
}

