/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.event;

import java.util.ArrayList;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.db.DataTransferDBManager;
import org.gcube.datatransfer.agent.impl.event.AgentFunctions;
import org.gcube.datatransfer.agent.impl.jdo.Transfer;
import org.gcube.datatransfer.agent.stubs.datatransferagent.GetTransferOutcomesFault;
import org.gcube.datatransfer.agent.stubs.datatransferagent.MonitorTransferFault;
import org.gcube.datatransfer.common.agent.Types;
import org.gcube.datatransfer.common.messaging.MSGClient;
import org.gcube.datatransfer.common.messaging.messages.TransferResponseMessage;
import org.gcube.datatransfer.common.outcome.FileTransferOutcome;
import org.gcube.datatransfer.common.outcome.TransferStatus;

public class ProduceResponse {
    private static String transferId;
    private static MSGClient msgClient;
    private static String scope;
    private static DataTransferDBManager dbManager;
    private static final GCUBELog logger;

    public static void notify(String id) {
        String address;
        ScopeProvider.instance.set(scope.toString());
        AgentFunctions agentFunctions = new AgentFunctions();
        transferId = id;
        EndpointReferenceType endpoint = ServiceContext.getContext().getInstance().getAccessPoint().getEndpoint("gcube/datatransfer/agent/DataTransferAgent");
        String sourceEndpoint = address = endpoint.getAddress().toString();
        String[] parts = address.split("/");
        if (parts.length >= 3) {
            sourceEndpoint = parts[0] + "//" + parts[2];
        }
        Transfer transfer = (Transfer)dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)transferId);
        String status = transfer.getStatus();
        String destEndpoint = transfer.getSubmitterEndpoint();
        if (destEndpoint == null) {
            logger.error((Object)("submitterEndpoint is null for the transfer with id: " + transferId + " ..return.."));
            return;
        }
        logger.debug((Object)("ProduceResponse -- Sending response to.. destEndpoint=" + destEndpoint + " for the transfer with id=" + transferId));
        TransferResponseMessage message = new TransferResponseMessage();
        message.setTransferId(transferId);
        message.setSourceEndpoint(sourceEndpoint);
        message.setDestEndpoint(destEndpoint);
        message.setTransferStatus(status);
        if (status.compareTo(TransferStatus.STARTED.toString()) == 0 || status.compareTo(TransferStatus.QUEUED.toString()) == 0) {
            try {
                Types.MonitorTransferReportMessage monitorRes = agentFunctions.monitorTransferWithProgress(transferId);
                message.setMonitorResponse(monitorRes);
            }
            catch (MonitorTransferFault e) {
                logger.error((Object)"ProduceTransferRes - MonitorTransferFault");
                e.printStackTrace();
                return;
            }
        }
        ArrayList<FileTransferOutcome> outcomesResponse = null;
        try {
            outcomesResponse = agentFunctions.getTransferOutcomes(transferId);
            message.setOutcomesResponse(outcomesResponse);
        }
        catch (GetTransferOutcomesFault e) {
            logger.error((Object)"ProduceTransferRes - GetTransferOutcomesFault");
            e.printStackTrace();
        }
        catch (Exception e) {
            logger.error((Object)"ProduceTransferRes - Exception");
            e.printStackTrace();
        }
        message.setOutcomesResponse(outcomesResponse);
        try {
            dbManager.updateLastNotificationMsgSent(transferId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            msgClient.sendResponseMessage((GCUBEServiceContext)ServiceContext.getContext(), message, new GCUBEScope[]{GCUBEScope.getScope((String)scope)});
        }
        catch (GCUBEScope.MalformedScopeExpressionException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        msgClient = ServiceContext.getContext().getMsgClient();
        scope = ScopeProvider.instance.get();
        dbManager = ServiceContext.getContext().getDbManager();
        logger = new GCUBELog(ProduceResponse.class);
    }
}

