/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.context;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.event.TransferDBChecker;
import org.gcube.datatransfer.agent.impl.event.TransferRequestSubscription;
import org.gcube.datatransfer.common.messaging.MSGClientFactory;

public class AgentRIResourceConsumer
extends GCUBEResource.ResourceConsumer {
    GCUBELog logger = new GCUBELog((Object)this);

    protected void onAddScope(GCUBEResource.AddScopeEvent event) {
        for (GCUBEScope scope : (GCUBEScope[])event.getPayload()) {
            String address;
            ScopeProvider.instance.set(scope.toString());
            this.logger.debug((Object)("RIResourceConsumer - onAddScope.. scope=" + scope.toString()));
            this.logger.trace((Object)"creating transfer subscription");
            if (!ServiceContext.getContext().getUseMessaging()) continue;
            try {
                ServiceContext.getContext().setMsgClient(MSGClientFactory.getMSGClientInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            EndpointReferenceType endpoint = ServiceContext.getContext().getInstance().getAccessPoint().getEndpoint("gcube/datatransfer/agent/DataTransferAgent");
            String sourceEndpoint = address = endpoint.getAddress().toString();
            String[] parts = address.split("/");
            if (parts.length >= 3) {
                sourceEndpoint = parts[0] + "//" + parts[2];
            }
            this.logger.trace((Object)("current address of agent service: " + sourceEndpoint));
            TransferRequestSubscription subscriber = new TransferRequestSubscription(sourceEndpoint);
            subscriber.setScope(scope);
            try {
                subscriber.subscribe();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            TransferDBChecker checker = new TransferDBChecker();
            checker.run();
        }
    }
}

