package org.gcube.datatransfer.agent.impl.worker.async;

import static org.gcube.data.tml.proxies.TServiceFactory.*;

import org.gcube.common.clients.fw.queries.StatefulQuery;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.tml.proxies.TReader;
import org.gcube.data.tml.proxies.TServiceFactory;
import org.gcube.data.tml.proxies.TWriter;
import org.gcube.data.trees.data.Tree;
import org.gcube.datatransfer.agent.impl.event.Events.TransferTopics;
import org.gcube.datatransfer.agent.impl.streams.IdRemover;
import org.gcube.datatransfer.agent.impl.streams.StreamCopyListener;
import org.gcube.datatransfer.agent.impl.worker.ASyncWorker;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.SourceData;
import org.gcube.datatransfer.agent.impl.utils.Utils;



/**
 * 
 * @author Andrea Manzi(CERN)
 *
 */
public class TreeManagerAsyncWorker extends ASyncWorker{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	TWriter client_writer =null;
	TReader client_reader =null;
	StreamCopyListener listener = null;

	Stream<Tree> filtered = null;
	
	public TreeManagerAsyncWorker(String tranferID,SourceData source, DestData dest) {
		this.transferId = tranferID;
		this.sourceParameters = source;
		this.destParameters = dest;
		listener = new StreamCopyListener(tranferID,source, dest);
	}

	@Override
	public Object call() {

		logger.info("Preparing the transfer");
		Stream<Tree> stream = null;

		try {
			
			StatefulQuery queryRead = readSource().withId(sourceParameters.getInputSource().getSourceId()).build();
			client_reader = TServiceFactory.reader().matching(queryRead).build();
			
			StatefulQuery queryWrite = writeSource().withId(destParameters.getOutSourceId()).build();
			client_writer = TServiceFactory.writer().matching(queryWrite).build();
			
			ScopeProvider.instance.set(sourceParameters.getScope());
			stream = client_reader.get(Utils.getPattern(sourceParameters.getInputSource().getPattern()));
			
			filtered = Streams.pipe(stream).through(new IdRemover());
			filtered = Streams.monitor(filtered).with(listener);
			filtered = client_writer.add(filtered);
			
		}catch (Exception e){
			listener.sendEvent(TransferTopics.TRANSFER_FAIL,"Error performing the transfer!");
			logger.error("Error performing the transfer with id: " +transferId,e);
			return e;
		}
		

		finally {
			try {
				getResource().getWorkerMap().remove(transferId);
			} catch (Exception e) {
				e.printStackTrace();
				return e;
			}
		}
		
		if (this.task.isCancelled()){
			logger.debug("Transfer with id: " +transferId +" has been canceled");
			listener.sendEvent(TransferTopics.TRANSFER_CANCEL,"Transfer cancelled by the user!");
		}
		return true;

	}

}
