/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.worker.async;

import java.util.HashSet;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.VFS;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.handlers.StorageManagerAsyncHandler;
import org.gcube.datatransfer.agent.impl.jdo.TransferObject;
import org.gcube.datatransfer.agent.impl.utils.Constants;
import org.gcube.datatransfer.agent.impl.utils.TransferUtils;
import org.gcube.datatransfer.agent.impl.worker.ASyncWorker;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.SourceData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.StorageManagerDetails;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;

public class StorageManagerASyncWorker
extends ASyncWorker {
    private static final long serialVersionUID = 1L;
    GCUBELog logger = new GCUBELog(StorageManagerASyncWorker.class);
    private IClient client;

    public StorageManagerASyncWorker(String id, SourceData source, DestData dest) throws Exception {
        this.sourceParameters = source;
        this.destParameters = dest;
        this.transferId = id;
        StorageManagerDetails details = dest.getOutUri().getStorageManagerDetails();
        if (details == null) {
            throw new Exception("Missing storage Manager configuration details");
        }
        this.client = new StorageClient(details.getServiceClass(), details.getServiceName(), details.getOwner(), AccessType.valueOf((String)details.getAccessType().getValue()), GCUBEScope.getScope((String)source.getScope())).getClient();
    }

    public Object call() throws Exception {
        String[] urlInputs = this.sourceParameters.getInputURIs();
        String outPath = this.destParameters.getOutUri().getOutUris()[0];
        HashSet<TransferObject> transferObjects = new HashSet<TransferObject>();
        ServiceContext.getContext().getDbManager().storeTransfer(TransferUtils.createTransferJDO(this.transferId));
        try {
            ThreadGroup threadList = new ThreadGroup(this.transferId);
            String[] stringArray = urlInputs;
            int n = urlInputs.length;
            int n2 = 0;
            while (n2 < n) {
                String urlString = stringArray[n2];
                FileObject file = VFS.getManager().resolveFile(urlString);
                StorageManagerAsyncHandler transferHandler = new StorageManagerAsyncHandler(file, this.timeout, outPath, this.transferId, TransferType.FileBasedTransfer, this.client, this.destParameters);
                this.list.add(transferHandler);
                Thread t = new Thread(threadList, transferHandler);
                t.start();
                ++n2;
            }
            try {
                Thread[] tga = new Thread[threadList.activeCount()];
                threadList.enumerate(tga);
                Thread[] threadArray = tga;
                int n3 = tga.length;
                n = 0;
                while (n < n3) {
                    Thread t = threadArray[n];
                    this.logger.debug((Object)("waiting for thread" + t.getId()));
                    t.join();
                    ++n;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            this.logger.debug((Object)"Getting transferOBJ");
            for (StorageManagerAsyncHandler t : this.list) {
                transferObjects.add(t.getTransferObj());
            }
            this.logger.debug((Object)"Persisting objects");
            ServiceContext.getContext().getDbManager().storeTransferObject(transferObjects);
            ServiceContext.getContext().getDbManager().updateTransferObjectStatus(this.transferId, Constants.TransferStatus.DONE.name());
        }
        catch (Exception e) {
            ServiceContext.getContext().getDbManager().updateTransferObjectStatus(this.transferId, Constants.TransferStatus.FAILED.name());
            e.printStackTrace();
            return e;
        }
        return true;
    }
}

