/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.worker.sync;

import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.grs.GRSOutComeWriter;
import org.gcube.datatransfer.agent.impl.utils.TransferUtils;
import org.gcube.datatransfer.agent.impl.worker.SyncWorker;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.SourceData;

public class LocalFileTransferSyncWorker
extends SyncWorker {
    private static final long serialVersionUID = 1L;

    public LocalFileTransferSyncWorker(String tranferID, SourceData source, DestData dest) throws GRS2WriterException, FileSystemException {
        this.transferId = tranferID;
        this.sourceParameters = source;
        this.destParameters = dest;
        this.outcomeWriter = new GRSOutComeWriter(source.getInputURIs().length);
    }

    public Object call() throws Exception {
        String[] urlInputs = this.sourceParameters.getInputURIs();
        String outPath = this.destParameters.getOutUri().getOutUris()[0];
        InputStream streamIn = null;
        for (String urlString : urlInputs) {
            Exception exception = null;
            FileObject absoluteOutputFile = null;
            long startTime = 0L;
            try {
                FileObject file = VFS.getManager().resolveFile(urlString);
                URLConnection connection = file.getURL().openConnection();
                connection.setConnectTimeout(this.timeout);
                streamIn = connection.getInputStream();
                String outputFile = urlString.substring(urlString.lastIndexOf(File.separator) + 1);
                String relativeOutputFile = outPath + File.separator + outputFile;
                absoluteOutputFile = ServiceContext.getContext().getLocalFSManager().resolveFile(relativeOutputFile);
                FileObject absolutePath = ServiceContext.getContext().getLocalFSManager().resolveFile(outPath);
                absolutePath.createFolder();
                if (absoluteOutputFile.exists() && !this.destParameters.getOutUri().isOverwrite()) {
                    this.logger.error((Object)("the file represented by the URL " + urlString + " cannot be copied cause a file with the same name already exists"));
                    throw new Exception("the file represented by the URL " + urlString + " cannot be copied cause a local file with the same name already exists");
                }
                FileOutputStream streamOut = null;
                try {
                    streamOut = new FileOutputStream(absoluteOutputFile.getName().getPath());
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                    throw e1;
                }
                this.logger.debug((Object)("Copying file from URL " + urlString + "to : " + absoluteOutputFile.getName().getPath()));
                startTime = System.currentTimeMillis();
                IOUtils.copy((InputStream)streamIn, (OutputStream)streamOut);
                streamIn.close();
                ((OutputStream)streamOut).close();
                if (this.destParameters.getOutUri().isUnzip()) {
                    TransferUtils.unzipArchive(absolutePath.getName().getPath(), absoluteOutputFile.getName().getPath());
                    new File(absoluteOutputFile.getName().getPath()).delete();
                }
                this.logger.debug((Object)("File succesfully copied to " + absoluteOutputFile.getName().getPath()));
            }
            catch (Exception e) {
                e.printStackTrace();
                exception = e;
            }
            long endTime = System.currentTimeMillis();
            long transferTime = endTime - startTime;
            if (exception == null) {
                this.outcomeWriter.putField(urlString, absoluteOutputFile.getName().getPath(), transferTime, new Exception[0]);
                continue;
            }
            this.outcomeWriter.putField(urlString, absoluteOutputFile.getName().getPath(), transferTime, exception);
        }
        this.outcomeWriter.close();
        return true;
    }

    @Override
    public String getOutcomeLocator() throws GRS2WriterException {
        return this.outcomeWriter.writer.getLocator().toString();
    }
}

