/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.worker.async;

import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import java.util.HashSet;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.handlers.LocalFileTransferAsyncHandler;
import org.gcube.datatransfer.agent.impl.jdo.TransferObject;
import org.gcube.datatransfer.agent.impl.utils.Constants;
import org.gcube.datatransfer.agent.impl.utils.TransferUtils;
import org.gcube.datatransfer.agent.impl.worker.ASyncWorker;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.SourceData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;

public class LocalFileTransferASyncWorker
extends ASyncWorker {
    private static final long serialVersionUID = 1L;

    public LocalFileTransferASyncWorker(String tranferID, SourceData source, DestData dest) throws GRS2WriterException, FileSystemException {
        this.transferId = tranferID;
        this.sourceParameters = source;
        this.destParameters = dest;
    }

    public Object call() throws Exception {
        String[] urlInputs = this.sourceParameters.getInputURIs();
        String outPath = this.destParameters.getOutUri().getOutUris()[0];
        HashSet<TransferObject> transferObjects = new HashSet<TransferObject>();
        ServiceContext.getContext().getDbManager().storeTransfer(TransferUtils.createTransferJDO(this.transferId));
        ThreadGroup threadList = new ThreadGroup(this.transferId);
        for (String urlString : urlInputs) {
            FileObject file = VFS.getManager().resolveFile(urlString);
            LocalFileTransferAsyncHandler transferHandler = new LocalFileTransferAsyncHandler(file, this.timeout, outPath, this.transferId, TransferType.LocalFileBasedTransfer, this.destParameters);
            this.list.add(transferHandler);
            Thread t = new Thread(threadList, transferHandler);
            t.start();
        }
        try {
            Thread[] tga = new Thread[threadList.activeCount()];
            threadList.enumerate(tga);
            for (Thread t : tga) {
                this.logger.debug((Object)("waiting for thread" + t.getId()));
                t.join();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        this.logger.debug((Object)"Getting transferOBJ");
        for (LocalFileTransferAsyncHandler t : this.list) {
            transferObjects.add(t.getTransferObj());
        }
        try {
            this.logger.debug((Object)"Persisting objects");
            ServiceContext.getContext().getDbManager().storeTransferObject(transferObjects);
            ServiceContext.getContext().getDbManager().updateTransferObjectStatus(this.transferId, Constants.TransferStatus.DONE.name());
        }
        catch (Exception e) {
            ServiceContext.getContext().getDbManager().updateTransferObjectStatus(this.transferId, Constants.TransferStatus.FAILED.name());
            e.printStackTrace();
            throw e;
        }
        return true;
    }
}

