/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.handlers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.datatransfer.agent.impl.handlers.TransferHandler;
import org.gcube.datatransfer.agent.impl.utils.Constants;
import org.gcube.datatransfer.agent.impl.utils.TransferUtils;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;

public class StorageManagerAsyncHandler
extends TransferHandler {
    GCUBELog logger = new GCUBELog(this.getClass());
    IClient client = null;

    public StorageManagerAsyncHandler(FileObject inputFile, int timeout, String outPath, String transferId, TransferType type, IClient client, DestData data) {
        this.inputFile = inputFile;
        this.timeout = timeout;
        this.outPath = outPath;
        this.transferId = transferId;
        this.transferType = type;
        this.destData = data;
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long startTime = 0L;
        File tmpFile = null;
        try {
            FileOutputStream streamOut;
            URLConnection connection = this.inputFile.getURL().openConnection();
            connection.setConnectTimeout(this.timeout);
            InputStream streamIn = connection.getInputStream();
            try {
                tmpFile = File.createTempFile("data-transfer", ".tmp");
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw e1;
            }
            try {
                streamOut = new FileOutputStream(tmpFile);
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
                throw e1;
            }
            String outputFile = this.inputFile.getName().getBaseName();
            String absoluteOutputFile = this.outPath + File.separator + outputFile;
            this.transferObj = TransferUtils.createTransferObjectJDO(this.transferId, this.transferType);
            this.transferObj.setSourceURI(this.inputFile.getURL().toString());
            startTime = System.currentTimeMillis();
            IOUtils.copy((InputStream)streamIn, (OutputStream)streamOut);
            streamIn.close();
            streamOut.close();
            this.client.put(true).LFile(tmpFile.getAbsolutePath()).RFile(absoluteOutputFile);
            String outURL = this.client.getUrl().RFile(absoluteOutputFile);
            this.transferObj.setDestURI(outURL);
            this.transferObj.setSize(tmpFile.getTotalSpace());
            this.transferObj.setStatus(Constants.TransferStatus.DONE.name());
            this.transferObj.setOutcome("File succesfully copied to " + outURL);
            this.logger.debug((Object)("File succesfully copied to " + outURL));
        }
        catch (Exception e) {
            this.transferObj.setStatus(Constants.TransferStatus.FAILED.name());
            this.transferObj.setOutcome(e.getMessage());
            e.printStackTrace();
        }
        finally {
            long endTime = System.currentTimeMillis();
            this.transferObj.setTransferTime(endTime - startTime);
            tmpFile.delete();
        }
    }
}

