/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;

public abstract class DBManager {
    GCUBELog logger = new GCUBELog(DBManager.class);
    protected PersistenceManagerFactory persistenceFactory;
    protected static File backupFolder = null;
    protected String dbFileBaseFolder;
    protected String dbFileName;
    protected String dbName;
    protected static int backupIntervalMS = 3600000 * Integer.valueOf((String)ServiceContext.getContext().getProperty("scheduledBackupInHours", new boolean[]{true}));

    public synchronized void close() throws Exception {
        this.persistenceFactory.getPersistenceManager().getDataStoreConnection().close();
    }

    public synchronized void backup() throws SQLException, Exception {
        Query query = this.persistenceFactory.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)"CHECKPOINT");
        query.execute();
        backupFolder.mkdirs();
        new Thread(){

            @Override
            public void run() {
                try {
                    DBManager.this.zipFolder(new File(DBManager.this.dbFileBaseFolder).listFiles());
                }
                catch (Exception e) {
                    DBManager.this.logger.error((Object)"Error creating a backup for the DB", (Throwable)e);
                }
            }
        }.start();
    }

    public synchronized String queryJSON(String expression) throws SQLException, Exception {
        Statement statement = null;
        try {
            Connection conn = (Connection)this.persistenceFactory.getPersistenceManager().getDataStoreConnection().getNativeConnection();
            statement = conn.createStatement();
            String string = DBManager.toJSon(statement.executeQuery(expression));
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    public static String toJSon(ResultSet resultSet) throws SQLException {
        StringBuilder json = new StringBuilder();
        json.append("{\"data\":[");
        ResultSetMetaData metaData = resultSet.getMetaData();
        int numberOfColumns = metaData.getColumnCount();
        int row = 0;
        while (resultSet.next()) {
            if (row > 0) {
                json.append(",{");
            } else {
                json.append('{');
            }
            for (int column = 1; column <= numberOfColumns; ++column) {
                if (column > 1) {
                    json.append(',');
                }
                json.append(DBManager.quote(metaData.getColumnName(column)));
                json.append(':');
                json.append(DBManager.quote(resultSet.getString(column)));
            }
            json.append('}');
            ++row;
        }
        json.append("],\"total_count\":");
        json.append(row);
        json.append("}");
        return json.toString();
    }

    protected static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    protected void zipFolder(File[] files) throws Exception {
        byte[] buf = new byte[1024];
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmmssZ");
        String outFilename = backupFolder + File.separator + dateFormat.format(new Date().getTime()) + ".zip";
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outFilename));
        for (int i = 0; i < files.length; ++i) {
            int len;
            FileInputStream in = new FileInputStream(files[i]);
            out.putNextEntry(new ZipEntry(files[i].getAbsolutePath()));
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            in.close();
        }
        out.close();
        this.logger.debug((Object)("DB Backup created @ " + outFilename));
    }

    public static interface BaseConsumer {
        public void consume(ResultSet var1) throws Exception;
    }
}

