package org.gcube.datatransfer.agent.impl.worker;

import java.io.File;
import java.net.URI;

import org.gcube.datatransfer.agent.impl.readers.GRSFileReader;
import org.gcube.datatransfer.agent.impl.streams.StreamCopyListener;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.SourceData;

/**
 * 
 * @author Andrea Manzi(CERN)
 *
 */
public class AgentTransferWorker extends   Worker<SourceData, DestData>{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	
	StreamCopyListener listener = null;
	
	public AgentTransferWorker(String tranferID,SourceData source, DestData dest) {
		this.transferId = tranferID;
		this.sourceParameters = source;
		this.destParameters = dest;
		listener = new StreamCopyListener(tranferID,source, dest);
	}
	@Override
	public Object call() throws Exception {
		 String uri = sourceParameters.getInputURIs()[0];
		 String outFolder = destParameters.getOutUri().getOutUris()[0];
		 boolean overwrite = destParameters.getOutUri().isOverwrite();
		 File out = new File(outFolder);	 
		 GRSFileReader t= new GRSFileReader(new URI(uri),out,overwrite);
		 t.run();
		 return t.getOutcomeLocator();
	}

}
