/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.worker;

import java.util.concurrent.FutureTask;
import org.gcube.common.clients.gcore.StatefulQuery;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.delegates.PipedStream;
import org.gcube.data.streams.delegates.StreamListener;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.generators.Generator;
import org.gcube.data.tml.clients.ReaderClient;
import org.gcube.data.tml.clients.WriterClient;
import org.gcube.data.tml.clients.queries.QueryBuilder;
import org.gcube.data.trees.data.Tree;
import org.gcube.datatransfer.agent.impl.event.Events;
import org.gcube.datatransfer.agent.impl.streams.IdRemover;
import org.gcube.datatransfer.agent.impl.streams.StreamCopyListener;
import org.gcube.datatransfer.agent.impl.worker.Worker;
import org.gcube.datatransfer.agent.library.utils.Utils;
import org.gcube.datatransfer.agent.stubs.datatransferagent.AnyHolder;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.SourceData;

public class TreeManagerWorker
extends Worker<SourceData, DestData> {
    private static final long serialVersionUID = 1L;
    WriterClient client_writer = null;
    ReaderClient client_reader = null;
    StreamCopyListener listener = null;
    FutureTask task = null;

    public TreeManagerWorker(String tranferID, SourceData source, DestData dest) {
        this.transferId = tranferID;
        this.sourceParameters = source;
        this.destParameters = dest;
        this.listener = new StreamCopyListener(tranferID, source, dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object call() {
        this.logger.info((Object)"Preparing the transfer");
        Stream stream = null;
        PipedStream filtered = null;
        try {
            StatefulQuery queryRead = QueryBuilder.findReadSource().withName(this.sourceParameters.getInputSource().getSourceId()).build();
            StatefulQuery queryWrite = QueryBuilder.findWriteSource().withName(this.destParameters.getOutSourceId()).build();
            this.client_writer = new WriterClient(queryWrite);
            this.client_reader = new ReaderClient(queryRead);
            Utils.setCurrentScope((GCUBEScope)GCUBEScope.getScope((String)this.sourceParameters.getScope()));
            stream = this.client_reader.get(Utils.getPattern((AnyHolder)this.sourceParameters.getInputSource().getPattern()));
            filtered = Streams.pipe((Stream)stream).through((Generator)new IdRemover());
            filtered = Streams.monitor((Stream)filtered).with((StreamListener)this.listener);
            filtered = this.client_writer.add((Stream)filtered);
            while (filtered.hasNext() && !this.task.isCancelled()) {
                try {
                    this.logger.debug((Object)((Tree)filtered.next()).id());
                }
                catch (RuntimeException e) {
                    this.listener.sendEvent(Events.TransferTopics.TRANSFER_FAIL, "Error performing the transfer!");
                    this.logger.error((Object)("Error performing the transfer with id: " + this.transferId), (Throwable)e);
                    RuntimeException runtimeException = e;
                    filtered.close();
                    try {
                        this.getResource().getWorkerMap().remove(this.transferId);
                        return runtimeException;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                        return e2;
                    }
                }
            }
        }
        catch (Exception e) {
            this.listener.sendEvent(Events.TransferTopics.TRANSFER_FAIL, "Error performing the transfer!");
            this.logger.error((Object)("Error performing the transfer with id: " + this.transferId), (Throwable)e);
            Exception exception = e;
            return exception;
        }
        finally {
            filtered.close();
            try {
                this.getResource().getWorkerMap().remove(this.transferId);
            }
            catch (Exception e) {
                e.printStackTrace();
                return e;
            }
        }
        if (!this.task.isCancelled()) return true;
        this.logger.debug((Object)("Transfer with id: " + this.transferId + " has been canceled"));
        this.listener.sendEvent(Events.TransferTopics.TRANSFER_CANCEL, "Transfer cancelled by the user!");
        return true;
    }

    public FutureTask getTask() {
        return this.task;
    }

    public void setTask(FutureTask task) {
        this.task = task;
    }
}

