/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.worker;

import java.io.File;
import java.net.URI;
import org.gcube.datatransfer.agent.impl.readers.GRSFileReader;
import org.gcube.datatransfer.agent.impl.streams.StreamCopyListener;
import org.gcube.datatransfer.agent.impl.worker.Worker;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.SourceData;

public class AgentTransferWorker
extends Worker<SourceData, DestData> {
    private static final long serialVersionUID = 1L;
    StreamCopyListener listener = null;

    public AgentTransferWorker(String tranferID, SourceData source, DestData dest) {
        this.transferId = tranferID;
        this.sourceParameters = source;
        this.destParameters = dest;
        this.listener = new StreamCopyListener(tranferID, source, dest);
    }

    public Object call() throws Exception {
        String uri = this.sourceParameters.getInputURIs()[0];
        String outFolder = this.destParameters.getOutUri().getOutUris()[0];
        boolean overwrite = this.destParameters.getOutUri().isOverwrite();
        File out = new File(outFolder);
        GRSFileReader t = new GRSFileReader(new URI(uri), out, overwrite);
        t.run();
        return t.getOutcomeLocator();
    }
}

