/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.event;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.events.GCUBEConsumer;
import org.gcube.common.core.utils.events.GCUBEEvent;
import org.gcube.common.core.utils.events.GCUBETopic;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.event.Events;
import org.gcube.datatransfer.agent.impl.event.TransferOutcome;
import org.gcube.datatransfer.messaging.MSGClient;
import org.gcube.datatransfer.messaging.MSGClientFactory;
import org.gcube.datatransfer.messaging.TransferMessage;

public class TransferEventConsumer
implements GCUBEConsumer<Events.TransferTopics, Object> {
    GCUBELog logger = new GCUBELog(this.getClass());

    public <T1 extends Events.TransferTopics, P1> void onEvent(GCUBEEvent<T1, P1> ... events) {
        if (events == null) {
            return;
        }
        block6: for (GCUBEEvent<T1, P1> event : events) {
            Events.TransferTopics topic = (Events.TransferTopics)event.getTopic();
            switch (topic) {
                case TRANSFER_END: {
                    this.onTransfer(event);
                    continue block6;
                }
                case TRANSFER_START: {
                    this.onTransfer(event);
                    continue block6;
                }
                case TRANSFER_FAIL: {
                    this.onTransfer(event);
                    continue block6;
                }
                case TRANSFER_CANCEL: {
                    this.onTransfer(event);
                }
            }
        }
    }

    protected synchronized <P1, T1 extends GCUBETopic> void onTransfer(GCUBEEvent<T1, P1> event) {
        this.logger.debug((Object)((TransferOutcome)event.getPayload()).getOutcome());
        if (ServiceContext.getContext().getUseMessaging()) {
            this.sendToMSG(event);
        }
    }

    private <P1, T1 extends GCUBETopic> void sendToMSG(GCUBEEvent<T1, P1> event) {
        MSGClient client = null;
        try {
            client = MSGClientFactory.getMSGClientInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TransferOutcome outcome = (TransferOutcome)event.getPayload();
        TransferMessage message = new TransferMessage();
        message.setTransferId(outcome.getTransferId());
        message.setDestID(outcome.getDestID());
        message.setSourceGHN(GHNContext.getContext().getHostnameAndPort());
        message.setSourceID(outcome.getSourceID());
        message.setTopic("DATA.TRANSFER");
        message.setTransferOutcome(outcome.getOutcome());
        message.setTransferPhase(outcome.getTransferPhase());
        message.setTransferType(outcome.getTransferType().getValue());
        try {
            client.sendMessage((GCUBEServiceContext)ServiceContext.getContext(), message, new GCUBEScope[]{outcome.getScope()});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

