package org.gcube.datatransfer.agent.impl.worker;

import java.io.Serializable;
import java.util.concurrent.Callable;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.agent.impl.context.AgentContext;
import org.gcube.datatransfer.agent.impl.state.AgentResource;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.SourceData;


/**
 * 
 * @author Andrea Manzi(CERN)
 *
 * @param <T>
 * @param <V>
 */
public abstract class Worker<T extends SourceData, V extends DestData> implements Callable, Serializable {

	protected AgentResource getResource() throws Exception {
		return (AgentResource) AgentContext.getContext().getAgent();
	}

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	protected GCUBELog logger = new GCUBELog(this.getClass());
	
	protected T sourceParameters;
	
	protected V destParameters;	
	
	protected String transferId;
	
}
