package org.gcube.datatransfer.agent.impl.worker;

import java.util.concurrent.FutureTask;

import org.gcube.common.clients.gcore.StatefulQuery;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.tml.clients.ReaderClient;
import org.gcube.data.tml.clients.WriterClient;
import org.gcube.data.tml.clients.queries.QueryBuilder;
import org.gcube.data.trees.data.Tree;
import org.gcube.datatransfer.agent.impl.event.Events.TransferTopics;
import org.gcube.datatransfer.agent.impl.streams.IdRemover;
import org.gcube.datatransfer.agent.impl.streams.StreamCopyListener;
import org.gcube.datatransfer.agent.library.utils.Utils;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.SourceData;



/**
 * 
 * @author Andrea Manzi(CERN)
 *
 */
public class TreeManagerWorker extends Worker<SourceData, DestData>{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	WriterClient client_writer =null;
	ReaderClient client_reader =null;
	StreamCopyListener listener = null;
	
	FutureTask task= null;


	public TreeManagerWorker(String tranferID,SourceData source, DestData dest) {
		this.transferId = tranferID;
		this.sourceParameters = source;
		this.destParameters = dest;
		listener = new StreamCopyListener(tranferID,source, dest);
	}

	@Override
	public Object call() {

		logger.info("Preparing the transfer");

		Stream<Tree> stream = null;
		Stream<Tree> filtered = null;

		try {

			StatefulQuery queryRead = QueryBuilder.findReadSource().withName(sourceParameters.getInputSource().getSourceId()).build();
			StatefulQuery queryWrite = QueryBuilder.findWriteSource().withName(destParameters.getOutSourceId()).build();

			client_writer = new WriterClient(queryWrite);
			client_reader = new ReaderClient(queryRead);
			//for test
			//client_writer = new WriterClient(getWriterEndpoint());
			//client_reader = new ReaderClient(getReaderEndpoint());


			Utils.setCurrentScope(GCUBEScope.getScope(sourceParameters.getScope()));
			stream = client_reader.get(Utils.getPattern(sourceParameters.getInputSource().getPattern()));
			
			filtered = Streams.pipe(stream).through(new IdRemover());
			filtered = Streams.monitor(filtered).with(listener);
			filtered = client_writer.add(filtered);

			while(filtered.hasNext() && !(this.task.isCancelled())){

				try {
					logger.debug(filtered.next().id());
				}

				catch(RuntimeException e) {
					listener.sendEvent(TransferTopics.TRANSFER_FAIL,"Error performing the transfer!");
					logger.error("Error performing the transfer with id: "+ transferId,e);
					return e;
				}

			}
		}catch (Exception e){
			listener.sendEvent(TransferTopics.TRANSFER_FAIL,"Error performing the transfer!");
			logger.error("Error performing the transfer with id: " +transferId,e);
			return e;
		}
		

		finally {
			filtered.close();
			try {
				getResource().getWorkerMap().remove(transferId);
			} catch (Exception e) {
				e.printStackTrace();
				return e;
			}
		}
		
		if (this.task.isCancelled()){
			logger.debug("Transfer with id: " +transferId +" has been canceled");
			listener.sendEvent(TransferTopics.TRANSFER_CANCEL,"Transfer cancelled by the user!");
		}
		return true;

	}



	public FutureTask getTask() {
		return task;
	}

	public void setTask(FutureTask task) {
		this.task = task;
	}
/*
	private EndpointReferenceType getWriterEndpoint() throws Exception{
		
		SourceBinding binding = null;
		RequestBinder binder = new RequestBinder();

		BindSource request  =new BindSource(destParameters.getOutSourceId());
		
		TBinderClient client = new BinderClient(new URL("http://d4science-dt.cern.ch:8443"));
		Utils.setCurrentScope(GCUBEScope.getScope(sourceParameters.getScope()));
		List<SourceBinding> bindings = client.bind(new BindingParameters("tree-repository",binder.bind(request),false));

		binding = bindings.get(0);
		
		return binding.getWriterEndpoint();
	}
	

	private EndpointReferenceType getReaderEndpoint() throws Exception{
		
		SourceBinding binding = null;
		RequestBinder binder = new RequestBinder();

		BindSource request  =new BindSource(sourceParameters.getInputSource().getSourceId());
		
		TBinderClient client = new BinderClient(new URL("http://d4science-dt.cern.ch:8443"));
		Utils.setCurrentScope(GCUBEScope.getScope(sourceParameters.getScope()));
		List<SourceBinding> bindings = client.bind(new BindingParameters("tree-repository",binder.bind(request),false));

		binding = bindings.get(0);
		
		return binding.getReaderEndpoint();
	}
	*/

}
