package org.gcube.datatransfer.agent.library.plugins;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.datatransfer.agent.library.AgentLibrary;
import org.gcube.datatransfer.agent.library.Constants;
import org.gcube.datatransfer.agent.library.exceptions.*;
import org.gcube.datatransfer.agent.stubs.datatransferagent.CancelTransferFault;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DataTransferAgentPortType;
import org.gcube.datatransfer.agent.stubs.datatransferagent.GetTransferOutcomesFault;
import org.gcube.datatransfer.agent.stubs.datatransferagent.MonitorTransferFault;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferFault;
import org.gcube.datatransfer.agent.stubs.datatransferagent.service.DataTransferAgentServiceAddressingLocator;



public class AgentServicePlugin  extends AbstractPlugin<DataTransferAgentPortType,AgentLibrary> {

	public AgentServicePlugin() {
		super(Constants.SERVICE_NAME);
	}
	
	
	
	public DataTransferAgentPortType resolve(EndpointReferenceType address,ProxyConfig<?,?> config) throws Exception {
		return new DataTransferAgentServiceAddressingLocator().getDataTransferAgentPortTypePort(address);
		
	}
	
	@Override
	public AgentLibrary newProxy(ProxyDelegate<DataTransferAgentPortType> delegate) {
		return new AgentLibrary(delegate);
	}

	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> arg1) {
		if (fault instanceof GCUBEFault)
			return new Exception();
		if (fault instanceof TransferFault)
			return new TransferException();
		if (fault instanceof CancelTransferFault)
			return new CancelTransferException();
		if (fault instanceof MonitorTransferFault)
			return new MonitorTransferException();
		if (fault instanceof GetTransferOutcomesFault)
			return new GetTransferOutcomesException();
		
		return fault;
	}
}