package org.gcube.datatransfer.agent.library.utils;

import static org.gcube.data.trees.patterns.Patterns.*;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.StringField;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.axis.message.MessageElement;
import org.gcube.common.core.faults.ExceptionProxy;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.io.Bindings;
import org.gcube.data.trees.patterns.Pattern;
import org.gcube.data.trees.patterns.Patterns;
import org.gcube.datatransfer.agent.library.outcome.FileTransferOutcome;
import org.gcube.datatransfer.agent.stubs.datatransferagent.AnyHolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * 
 * 
 * @author Fabio Simeoni (FAO)
 * @author Andrea Manzi (CERN)
 */
public class Utils {
	
	
	public static GCUBEClientLog logger= new GCUBEClientLog(Utils.class);
	
	
	private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();


	/**
	 * Converts a {@link AnyHolder} returned by the service into a {@link Pattern}.
	 * @param h the holder
	 * @return the pattern
	 * @throws Exception if the conversion fails
	 */
	public static Pattern getPattern(AnyHolder h) throws Exception {

		return h==null?null: (Pattern) getUnMarshaller().unmarshal(h.get_any()[0].getAsDOM());

	}


	public static AnyHolder toHolder(Pattern p) throws Exception {

		if (p==null) 
			return null;

		Document filterNode = factory.newDocumentBuilder().newDocument();
		Patterns.getMarshaller().marshal(p, filterNode);
		return toHolder(filterNode.getDocumentElement());

	}
	/* Converts an {@link Element} into a {@link AnyHolder} accepted by the service.
	 * @param e the element
	 * @return the holder
	 */
	public static AnyHolder toHolder(Element e) {

		return e==null?null:new AnyHolder(new MessageElement[]{new MessageElement(e)});

	}

	/**
	 * Transforms a {@link Node} into a {@link AnyHolder} accepted by the service.
	 * @param n the node
	 * @return the holder
	 * @throws Exception if the conversion fails
	 */
	public static AnyHolder toHolder(Node n) throws Exception {

		return n==null?null:toHolder(Bindings.nodeToElement(n));

	}

	static public void setCurrentScope(GCUBEScope scope) {
		GCUBEScopeManager.DEFAULT.setScope(scope);
	}

	public static void copyfile(File f1, File f2) throws IOException{

		InputStream in = new FileInputStream(f1);
		OutputStream out = new FileOutputStream(f2);

		byte[] buf = new byte[1024];
		int len;
		while ((len = in.read(buf)) > 0){
			out.write(buf, 0, len);
		}
		in.close();
		out.close();

	}
	
	
	/**
	 * Returns a given fault after serialising into it an original cause.
	 * @param fault the fault
	 * @param cause the cause
	 * @return the fault
	 * @param <E> the type of the fault
	 */
	public static <E extends GCUBEFault> E newFault(E fault, Throwable cause) {
		
		fault.setFaultMessage(cause.getMessage());
		
		fault.removeFaultDetail(new QName("http://xml.apache.org/axis/","stackTrace"));
		
		//adds whole stacktrace as single detail element
		StringWriter w = new StringWriter();
		cause.printStackTrace(new PrintWriter(w));
		fault.addFaultDetailString(w.toString());
		
		try {
			fault.addFaultDetail(ExceptionProxy.newInstance(cause).toElement());
		}
		catch(Exception e) {}
		
		return fault;
		
	}


	public static void copyfileToFolder(File file, File outFolder, String fileName) throws IOException{
		
		InputStream in = new FileInputStream(file);
		OutputStream out = new FileOutputStream(outFolder.getAbsolutePath()+File.separator+fileName);

		byte[] buf = new byte[1024];
		int len;
		while ((len = in.read(buf)) > 0){
			out.write(buf, 0, len);
		}
		in.close();
		out.close();
		
	}

	public static ArrayList<FileTransferOutcome> getOutcomes(String outcomeRSURI) throws Exception{
		
		ForwardReader<GenericRecord> reader=new ForwardReader<GenericRecord>(new URI(outcomeRSURI));
		ArrayList<FileTransferOutcome> outcomes = new ArrayList<FileTransferOutcome>();
		
		for ( GenericRecord rec : reader){
			if(rec==null) 
				continue;
			StringField fileNamefield = ((StringField) rec.getField("FileNameField"));
			logger.debug("FileName :" +fileNamefield.getPayload());
			StringField outcomeField = ((StringField) rec.getField("OutcomeField"));
			logger.debug("Outcome :" +outcomeField.getPayload());
			StringField exceptionField = ((StringField) rec.getField("ExceptionField"));
			logger.debug("Exception: "+exceptionField.getPayload());
			
			FileTransferOutcome outcome = new FileTransferOutcome(fileNamefield.getPayload());
			outcome.setException(exceptionField.getPayload());
			outcomes.add(outcome);
			}
		try {
			reader.close();
		} catch (GRS2ReaderException e1) {
			e1.printStackTrace();
		}
		return outcomes;
	}

}
