package org.gcube.datatransfer.agent.library.calls;

import java.util.ArrayList;
import java.util.List;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.calls.RICall;
import org.gcube.datatransfer.agent.stubs.datatransferagent.CancelTransferMessage;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DataTransferAgentPortType;
import org.gcube.datatransfer.agent.stubs.datatransferagent.StartTransferMessage;
import org.gcube.datatransfer.agent.stubs.datatransferagent.service.DataTransferAgentServiceAddressingLocator;


/**
 * 
 * @author Andrea Manzi(CERN)
 *
 */

public class AgentServiceCall extends RICall implements AgentServiceCallInterface{
	

	static int callTimeout=240000;
	static String SERVICE_CLASS="DataTransfer";
	static String SERVICE_NAME="agent-service";
	
	public AgentServiceCall(GCUBEScope scope,
			GCUBESecurityManager[] securityManager) throws Exception {
		super(scope, securityManager);
	}

	public String startTransfer(final StartTransferMessage message) throws Exception {
		final ResultHolder<String> result = new ResultHolder<String>();
		new RICallHandler() {
			public void interact(EndpointReferenceType epr) throws Exception {
				DataTransferAgentPortType PT= new DataTransferAgentServiceAddressingLocator().getDataTransferAgentPortTypePort(epr);
				PT=GCUBERemotePortTypeContext.getProxy(PT, getScopeManager(),callTimeout);
				result.value = PT.startTransfer(message);
			}
			
			protected List<EndpointReferenceType> findInstances() throws Exception {
				return findPortType(getRIQuery(),getPortTypeName());
			}
			
		}.run();
		return result.value;
	}

	public String startLocalFileTransfer(final StartTransferMessage message) throws Exception {
		final ResultHolder<String> result = new ResultHolder<String>();
		new RICallHandler() {
			public void interact(EndpointReferenceType epr) throws Exception {
				DataTransferAgentPortType PT= new DataTransferAgentServiceAddressingLocator().getDataTransferAgentPortTypePort(epr);
				PT=GCUBERemotePortTypeContext.getProxy(PT, getScopeManager(),callTimeout);
				result.value = PT.startTransfer(message);
			}
			
			protected List<EndpointReferenceType> findInstances() throws Exception {
				return findPortType(getRIQuery(),getPortTypeName());
			}
			
		}.run();
		return result.value;
	
	}

	@Override
	protected String getPortTypeName() {
		return "gcube/datatransfer/agent/DataTransferAgent";
		}


	@Override
	protected String getServiceClass() {
		return SERVICE_CLASS;
	}

	@Override
	protected String getServiceName() {
		return SERVICE_NAME;
	}
	
	@Override
	protected GCUBERIQuery getRIQuery() throws Exception {
		GCUBERIQuery q = GHNContext.getImplementation(ISClient.class).getQuery(GCUBERIQuery.class);
		//if (q == null) throw new Exception();
		//q.addAtomicConditions(	new AtomicCondition("//ServiceName",getServiceName()), new AtomicCondition("//ServiceClass",getServiceClass()));
		
		return q;
	}
	
	protected List<EndpointReferenceType> findPortType(GCUBERIQuery query,String portType) throws Exception {
		ISClient client = GHNContext.getImplementation(ISClient.class);
		List<EndpointReferenceType> eprs = new ArrayList<EndpointReferenceType>();
		for (GCUBERunningInstance instance : client.execute(query, getScopeManager().getScope())) 
			if (instance.getAccessPoint().getEndpoint(portType)!=null)
				eprs.add(instance.getAccessPoint().getEndpoint(portType));
		return eprs;
	}

	public String cancelTransfer(final CancelTransferMessage message) throws Exception {
		final ResultHolder<String> result = new ResultHolder<String>();
		new RICallHandler() {
			public void interact(EndpointReferenceType epr) throws Exception {
				DataTransferAgentPortType PT= new DataTransferAgentServiceAddressingLocator().getDataTransferAgentPortTypePort(epr);
				PT=GCUBERemotePortTypeContext.getProxy(PT, getScopeManager(),callTimeout);
				result.value = PT.cancelTransfer(message);
			}
			
			protected List<EndpointReferenceType> findInstances() throws Exception {
				return findPortType(getRIQuery(),getPortTypeName());
			}
			
		}.run();
		return result.value;
	}

}

