package de.uni_jena.cs.fusion.client.worms;

/*-
 * #%L
 * LakeBase Semantic Service
 * %%
 * Copyright (C) 2018 Heinz Nixdorf Chair for Distributed Information Systems, Friedrich Schiller University Jena
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import java.util.Collection;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Jan Martin Keil
 * @since 1.0.0
 */
public class AttributeValue {
	/**
	 * An identifier for facts stored in the column measurementValue
	 */
	@JsonProperty("measurementValueID")
	public int measurementValueId;

	/**
	 * The value of the measurement, fact, characteristic, or assertion
	 */
	public String measurementValue;

	/**
	 * Additional info/code that helps to the describe/define the
	 * measurementValue
	 */
	public String measurementValueCode;

	/**
	 * Child measurementValues that are more specific
	 */
	public Collection<AttributeValue> children;
}
