/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.wormsplugin.capabilities;

import de.uni_jena.cs.fusion.client.worms.AphiaRecord;
import de.uni_jena.cs.fusion.client.worms.WormsClientException;
import java.util.Collection;
import java.util.HashSet;
import org.gcube.data.spd.model.exceptions.ExternalRepositoryException;
import org.gcube.data.spd.plugin.fwk.capabilities.MappingCapability;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;
import org.gcube.data.spd.wormsplugin.WormsPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamesMappingImpl
implements MappingCapability {
    private static Logger logger = LoggerFactory.getLogger(NamesMappingImpl.class);

    public void getRelatedScientificNames(ObjectWriter<String> writer, String commonName) throws ExternalRepositoryException {
        try {
            Collection<AphiaRecord> records;
            logger.debug("retrieving mapping for " + commonName);
            int offsetlimit = 50;
            int offset = 1;
            HashSet<String> snSet = new HashSet<String>();
            do {
                if ((records = WormsPlugin.wormsClient.aphiaRecordsByVernacular(commonName, true, offset)) != null) {
                    for (AphiaRecord record : records) {
                        if (!writer.isAlive()) {
                            return;
                        }
                        if (snSet.contains(record.scientificName)) continue;
                        logger.trace("writing (COMMONNAMESMAPPING) " + record.scientificName);
                        writer.write((Object)record.scientificName);
                        snSet.add(record.scientificName);
                    }
                }
                offset += 50;
            } while (records != null && records.size() == 50);
        }
        catch (WormsClientException e) {
            throw new ExternalRepositoryException((Throwable)e);
        }
    }
}

