/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.wormsplugin.capabilities;

import de.uni_jena.cs.fusion.client.worms.AphiaRecord;
import de.uni_jena.cs.fusion.client.worms.WormsClientException;
import java.util.Collection;
import org.gcube.data.spd.model.exceptions.ExternalRepositoryException;
import org.gcube.data.spd.model.exceptions.StreamException;
import org.gcube.data.spd.model.exceptions.StreamNonBlockingException;
import org.gcube.data.spd.plugin.fwk.capabilities.ExpansionCapability;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;
import org.gcube.data.spd.wormsplugin.WormsPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpansionCapabilityImpl
implements ExpansionCapability {
    Logger logger = LoggerFactory.getLogger(ExpansionCapabilityImpl.class);

    public void getSynonyms(ObjectWriter<String> writer, String scientifcName) throws ExternalRepositoryException {
        this.logger.debug("searching synonyms for " + scientifcName);
        int offset = 1;
        int elements = 20;
        Collection<AphiaRecord> records = null;
        do {
            try {
                records = WormsPlugin.wormsClient.aphiaRecordsByName(scientifcName, true, false, offset);
                if (records != null) {
                    for (AphiaRecord record : records) {
                        try {
                            Collection<AphiaRecord> synonyms = WormsPlugin.wormsClient.aphiaSynonymsByAphiaId(record.aphiaId);
                            if (synonyms == null) continue;
                            for (AphiaRecord synonym : synonyms) {
                                if (!writer.isAlive()) {
                                    return;
                                }
                                writer.write((Object)synonym.scientificName);
                                this.logger.debug("found synonym " + synonym.scientificName);
                            }
                        }
                        catch (Exception e) {
                            writer.write((StreamException)new StreamNonBlockingException("WoRMS", scientifcName));
                            this.logger.error("error retrieving synonyms for aphia id " + record.aphiaId, (Throwable)e);
                        }
                    }
                }
            }
            catch (WormsClientException e) {
                throw new ExternalRepositoryException((Throwable)e);
            }
            offset = elements + offset;
        } while (records != null && records.size() == offset);
    }
}

