/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.wormsplugin;

import de.uni_jena.cs.fusion.client.worms.AphiaRecord;
import de.uni_jena.cs.fusion.client.worms.Classification;
import de.uni_jena.cs.fusion.client.worms.Vernacular;
import de.uni_jena.cs.fusion.client.worms.WormsClientException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import org.gcube.data.spd.model.CommonName;
import org.gcube.data.spd.model.products.Taxon;
import org.gcube.data.spd.model.products.TaxonomyItem;
import org.gcube.data.spd.model.products.TaxonomyStatus;
import org.gcube.data.spd.wormsplugin.WormsPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    static Logger logger = LoggerFactory.getLogger(Utils.class);

    public static Taxon retrieveTaxon(Classification classification, long aphiaID) {
        Taxon taxon = null;
        while ((long)classification.aphiaId != aphiaID) {
            Taxon newTaxon = new Taxon(classification.aphiaId + "");
            if (taxon != null) {
                newTaxon.setParent(taxon);
            }
            newTaxon.setRank(classification.taxonomicRank);
            newTaxon.setScientificName(classification.scientificName);
            classification = classification.child;
            taxon = newTaxon;
        }
        return taxon;
    }

    public static TaxonomyItem retrieveTaxonomy(Classification classification, long aphiaID) {
        ArrayList<CommonName> listCommNames = new ArrayList<CommonName>();
        TaxonomyItem taxon = null;
        while ((long)classification.aphiaId != aphiaID) {
            int id = classification.aphiaId;
            TaxonomyItem newTaxon = new TaxonomyItem(id + "");
            if (taxon != null) {
                newTaxon.setParent(taxon);
            }
            newTaxon.setRank(classification.taxonomicRank);
            newTaxon.setScientificName(classification.scientificName);
            newTaxon.setCredits(Utils.createCredits());
            AphiaRecord record = null;
            try {
                record = WormsPlugin.wormsClient.aphiaRecordByAphiaId(id);
            }
            catch (Exception e) {
                logger.error("Error getAphiaRecordByID ", (Throwable)e);
            }
            if (record != null) {
                newTaxon.setCitation(record.citation);
                newTaxon.setLsid(record.lsid);
                newTaxon.setScientificNameAuthorship(record.authority);
            }
            try {
                Collection<Vernacular> vernaculars = WormsPlugin.wormsClient.aphiaVernacularsByAphiaId(classification.aphiaId);
                if (vernaculars != null) {
                    for (Vernacular vernacular : vernaculars) {
                        if (vernacular.languageCode == null) continue;
                        CommonName a = new CommonName(vernacular.language, vernacular.vernacular);
                        listCommNames.add(a);
                    }
                }
            }
            catch (WormsClientException e) {
                logger.error("RemoteException", (Throwable)e);
            }
            newTaxon.setCommonNames(listCommNames);
            newTaxon.setStatus(new TaxonomyStatus("accepted", TaxonomyStatus.Status.ACCEPTED));
            classification = classification.child;
            taxon = newTaxon;
        }
        return taxon;
    }

    public static String createDate() {
        Calendar now = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String date = format.format(now.getTime());
        return date;
    }

    public static String createCredits() {
        String cred = WormsPlugin.credits;
        cred = cred.replace("XDATEX", Utils.createDate());
        return cred;
    }
}

