/*
 * Decompiled with CFR 0.152.
 */
package de.uni_jena.cs.fusion.client.worms;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.uni_jena.cs.fusion.client.worms.AphiaAttributeSets;
import de.uni_jena.cs.fusion.client.worms.AphiaRecord;
import de.uni_jena.cs.fusion.client.worms.Attribute;
import de.uni_jena.cs.fusion.client.worms.AttributeKey;
import de.uni_jena.cs.fusion.client.worms.AttributeValue;
import de.uni_jena.cs.fusion.client.worms.Classification;
import de.uni_jena.cs.fusion.client.worms.Distribution;
import de.uni_jena.cs.fusion.client.worms.ExternalIdentifierSource;
import de.uni_jena.cs.fusion.client.worms.Source;
import de.uni_jena.cs.fusion.client.worms.Vernacular;
import de.uni_jena.cs.fusion.client.worms.WormsClientException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.client.cache.HttpCacheContext;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;

public class WormsClient {
    private static final int HTTP_MAX_URL_BYTES = 7806;
    private static final String SERVICE_URL = "http://www.marinespecies.org/rest/";
    private static final ObjectMapper JSON = new ObjectMapper();
    private final CloseableHttpClient httpClient;

    public WormsClient() {
        this(HttpClientBuilder.create().build());
    }

    public WormsClient(CloseableHttpClient httpClient) {
        this.httpClient = Objects.requireNonNull(httpClient);
    }

    public Collection<AttributeKey> aphiaAttributeKeysById(long id, boolean includeChildren) throws WormsClientException {
        return this.request("http://www.marinespecies.org/rest/AphiaAttributeKeysByID/" + id + (includeChildren ? "?include_inherited=true" : ""), new TypeReference<ArrayList<AttributeKey>>(){});
    }

    public Collection<Attribute> aphiaAttributesByAphiaId(long aphiaId, boolean includeChildren) throws WormsClientException {
        return this.request("http://www.marinespecies.org/rest/AphiaAttributesByAphiaID/" + aphiaId + (includeChildren ? "?include_inherited=true" : ""), new TypeReference<ArrayList<Attribute>>(){});
    }

    public Collection<AttributeValue> aphiaAttributeValuesByCategoryId(long id) throws WormsClientException {
        return this.request("http://www.marinespecies.org/rest/AphiaAttributeValuesByCategoryID/" + id, new TypeReference<ArrayList<AttributeValue>>(){});
    }

    public Collection<AphiaRecord> aphiaChildrenByAphiaId(long aphiaId, boolean marineOnly) throws WormsClientException {
        Collection<AphiaRecord> singleResult;
        ArrayList<AphiaRecord> totalResult = new ArrayList<AphiaRecord>();
        long offset = 1L;
        do {
            singleResult = this.aphiaChildrenByAphiaId(aphiaId, marineOnly, offset);
            totalResult.addAll(singleResult);
            offset += 50L;
        } while (singleResult.size() == 50);
        return totalResult;
    }

    public Collection<AphiaRecord> aphiaChildrenByAphiaId(long aphiaId, boolean marineOnly, long offset) throws WormsClientException {
        return this.request("http://www.marinespecies.org/rest/AphiaChildrenByAphiaID/" + aphiaId + "?marine_only=" + marineOnly + "&offset=" + offset, new TypeReference<ArrayList<AphiaRecord>>(){});
    }

    public Classification aphiaClassificationByAphiaId(long aphiaId) throws WormsClientException {
        return this.request("http://www.marinespecies.org/rest/AphiaClassificationByAphiaID/" + aphiaId, new TypeReference<Classification>(){});
    }

    public Collection<Distribution> aphiaDistributionsByAphiaId(long aphiaId) throws WormsClientException {
        return this.request("http://www.marinespecies.org/rest/AphiaDistributionsByAphiaID/" + aphiaId, new TypeReference<ArrayList<Distribution>>(){});
    }

    public Collection<String> aphiaExternalIdByAphiaId(long aphiaId, ExternalIdentifierSource type) throws WormsClientException {
        return this.request("http://www.marinespecies.org/rest/AphiaExternalIDByAphiaID/" + aphiaId + "?type=" + type.name(), new TypeReference<ArrayList<String>>(){});
    }

    public Long aphiaIdByName(String scientificName) throws WormsClientException {
        try {
            return this.request("http://www.marinespecies.org/rest/AphiaIDByName/" + URLEncoder.encode(scientificName, "UTF-8").replace("+", "%20"), new TypeReference<Long>(){});
        }
        catch (UnsupportedEncodingException e) {
            throw new WormsClientException(e);
        }
    }

    public Collection<AphiaAttributeSets> aphiaIdsByAttributeKeyId(long id) throws WormsClientException {
        Collection<AphiaAttributeSets> singleResult;
        ArrayList<AphiaAttributeSets> totalResult = new ArrayList<AphiaAttributeSets>();
        long offset = 1L;
        do {
            singleResult = this.aphiaIdsByAttributeKeyId(id, offset);
            totalResult.addAll(singleResult);
            offset += 50L;
        } while (singleResult.size() == 50);
        return totalResult;
    }

    public Collection<AphiaAttributeSets> aphiaIdsByAttributeKeyId(long id, long offset) throws WormsClientException {
        return this.request("http://www.marinespecies.org/rest/AphiaIDsByAttributeKeyID/" + id, new TypeReference<ArrayList<AphiaAttributeSets>>(){});
    }

    public String aphiaNameByAphiaId(long aphiaId) throws WormsClientException {
        return this.request("http://www.marinespecies.org/rest/AphiaNameByAphiaID/" + aphiaId, new TypeReference<String>(){});
    }

    public AphiaRecord aphiaRecordByAphiaId(long aphiaId) throws WormsClientException {
        return this.request("http://www.marinespecies.org/rest/AphiaRecordByAphiaID/" + aphiaId, new TypeReference<AphiaRecord>(){});
    }

    public AphiaRecord aphiaRecordByExternalId(String id, ExternalIdentifierSource type) throws WormsClientException {
        try {
            return this.request("http://www.marinespecies.org/rest/AphiaRecordByExternalID/" + URLEncoder.encode(id, "UTF-8").replace("+", "%20") + "?type=" + type.name(), new TypeReference<AphiaRecord>(){});
        }
        catch (UnsupportedEncodingException e) {
            throw new WormsClientException(e);
        }
    }

    public Collection<AphiaRecord> aphiaRecordsByDate(TemporalAccessor statdate, TemporalAccessor enddate, boolean marineOnly) throws WormsClientException {
        Collection<AphiaRecord> singleResult;
        ArrayList<AphiaRecord> totalResult = new ArrayList<AphiaRecord>();
        long offset = 1L;
        do {
            singleResult = this.aphiaRecordsByDate(statdate, enddate, marineOnly, offset);
            totalResult.addAll(singleResult);
            offset += 50L;
        } while (singleResult.size() == 50);
        return totalResult;
    }

    public Collection<AphiaRecord> aphiaRecordsByDate(TemporalAccessor statdate, TemporalAccessor enddate, boolean marineOnly, long offset) throws WormsClientException {
        try {
            return this.request("http://www.marinespecies.org/rest/AphiaRecordsByDate?startdate=" + DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(statdate) + "&enddate=" + DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(enddate) + "&marine_only=" + marineOnly + "&offset=" + offset, new TypeReference<ArrayList<AphiaRecord>>(){});
        }
        catch (DateTimeException e) {
            throw new WormsClientException(e);
        }
    }

    public List<Collection<AphiaRecord>> aphiaRecordsByMatchNames(List<String> scientificNames, boolean marineOnly) throws WormsClientException {
        return this.requestPartitioned("http://www.marinespecies.org/rest/AphiaRecordsByMatchNames?scientificnames[]=", scientificNames, "&scientificnames[]=", 50, "&marine_only=" + marineOnly);
    }

    public Collection<AphiaRecord> aphiaRecordsByName(String scientificName, boolean like, boolean marineOnly) throws WormsClientException {
        Collection<AphiaRecord> singleResult;
        ArrayList<AphiaRecord> totalResult = new ArrayList<AphiaRecord>();
        long offset = 1L;
        do {
            singleResult = this.aphiaRecordsByName(scientificName, like, marineOnly, offset);
            totalResult.addAll(singleResult);
            offset += 50L;
        } while (singleResult.size() == 50);
        return totalResult;
    }

    public Collection<AphiaRecord> aphiaRecordsByName(String scientificName, boolean like, boolean marineOnly, long offset) throws WormsClientException {
        try {
            return this.request("http://www.marinespecies.org/rest/AphiaRecordsByName/" + URLEncoder.encode(Objects.requireNonNull(scientificName), "UTF-8").replace("+", "%20") + "?like=" + like + "&marine_only=" + marineOnly + "&offset=" + offset, new TypeReference<ArrayList<AphiaRecord>>(){});
        }
        catch (UnsupportedEncodingException e) {
            throw new WormsClientException(e);
        }
    }

    public List<Collection<AphiaRecord>> aphiaRecordsByNames(List<String> scientificNames, boolean like, boolean marineOnly) throws WormsClientException {
        return this.requestPartitioned("http://www.marinespecies.org/rest/AphiaRecordsByNames?scientificnames[]=", scientificNames, "&scientificnames[]=", 500, "&like=" + like + "&marine_only=" + marineOnly);
    }

    public Collection<AphiaRecord> aphiaRecordsByVernacular(String vernacular, boolean like) throws WormsClientException {
        Collection<AphiaRecord> singleResult;
        ArrayList<AphiaRecord> totalResult = new ArrayList<AphiaRecord>();
        long offset = 1L;
        do {
            singleResult = this.aphiaRecordsByVernacular(vernacular, like, offset);
            totalResult.addAll(singleResult);
            offset += 50L;
        } while (singleResult.size() == 50);
        return totalResult;
    }

    public Collection<AphiaRecord> aphiaRecordsByVernacular(String vernacular, boolean like, long offset) throws WormsClientException {
        try {
            return this.request("http://www.marinespecies.org/rest/AphiaRecordsByVernacular/" + URLEncoder.encode(Objects.requireNonNull(vernacular), "UTF-8").replace("+", "%20") + "?like=" + like + "&offset=" + offset, new TypeReference<ArrayList<AphiaRecord>>(){});
        }
        catch (UnsupportedEncodingException e) {
            throw new WormsClientException(e);
        }
    }

    public Collection<Source> aphiaSourcesByAphiaId(long aphiaId) throws WormsClientException {
        return this.request("http://www.marinespecies.org/rest/AphiaSourcesByAphiaID/" + aphiaId, new TypeReference<ArrayList<Source>>(){});
    }

    public Collection<AphiaRecord> aphiaSynonymsByAphiaId(long aphiaId) throws WormsClientException {
        return this.request("http://www.marinespecies.org/rest/AphiaSynonymsByAphiaID/" + aphiaId, new TypeReference<ArrayList<AphiaRecord>>(){});
    }

    public Collection<Vernacular> aphiaVernacularsByAphiaId(long aphiaId) throws WormsClientException {
        return this.request("http://www.marinespecies.org/rest/AphiaVernacularsByAphiaID/" + aphiaId, new TypeReference<ArrayList<Vernacular>>(){});
    }

    private <T> List<Collection<T>> ensureEmptyCollections(List<Collection<T>> list, long count) {
        if (list.isEmpty()) {
            return Stream.generate(() -> Collections.emptyList()).limit(count).collect(Collectors.toList());
        }
        return list;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    private <T> T request(String url, TypeReference<T> t) throws WormsClientException {
        context = HttpCacheContext.create();
        httpget = new HttpGet(url);
        try {
            response = this.httpClient.execute((HttpUriRequest)httpget, (HttpContext)context);
            var6_7 = null;
            if (response.getStatusLine().getStatusCode() == 200) {
                content = response.getEntity().getContent();
                var8_14 = null;
                var9_17 = WormsClient.JSON.readValue(content, t);
                return (T)var9_17;
                {
                    catch (Throwable var9_18) {
                        var8_14 = var9_18;
                        throw var9_18;
                    }
                    finally {
                        if (content != null) {
                            if (var8_14 != null) {
                                try {
                                    content.close();
                                }
                                catch (Throwable var10_19) {
                                    var8_14.addSuppressed(var10_19);
                                }
                            } else {
                                content.close();
                            }
                        }
                    }
                    {
                        catch (JsonParseException | JsonMappingException e) {
                            throw new WormsClientException("\"" + url + "\" returned invalid response.", e);
                        }
                    }
                }
            }
            ** if (response.getStatusLine().getStatusCode() != 204) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                if (WormsClient.JSON.getTypeFactory().constructType(t).isContainerType()) {
                    try {
                        e = WormsClient.JSON.getTypeFactory().constructType(t).getRawClass().newInstance();
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException e) {
                        throw new WormsClientException("Failed to instantiate empty result for \"" + url + "\".", e);
                    }
                    return e;
                }
                var7_12 = null;
                return var7_12;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    throw new WormsClientException("\"" + url + "\" returned " + response.getStatusLine().getStatusCode() + ".");
                }
                catch (Throwable var7_13) {
                    var6_7 = var7_13;
                    throw var7_13;
                }
            }
            finally {
                if (response != null) {
                    if (var6_7 != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable var10_20) {
                            var6_7.addSuppressed(var10_20);
                        }
                    } else {
                        response.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new WormsClientException("Request failed on \"" + url + "\".", e);
        }
    }

    private List<Collection<AphiaRecord>> requestPartitioned(String requestPrefix, List<String> names, String requestNameDelimiter, int maxNamesPerRequest, String requestPostfix) throws WormsClientException {
        ArrayList<Collection<AphiaRecord>> totalResult = new ArrayList<Collection<AphiaRecord>>();
        StringBuilder requestUrl = new StringBuilder(requestPrefix);
        long requestNames = 0L;
        for (String scientificName : names) {
            try {
                String scientificNameEncoded = URLEncoder.encode(scientificName, "UTF-8").replace("+", "%20");
                if (requestNames == (long)maxNamesPerRequest || requestUrl.length() + requestNameDelimiter.length() + scientificNameEncoded.length() + requestPostfix.length() > 7806) {
                    totalResult.addAll(this.ensureEmptyCollections((List)this.request(requestUrl.append(requestPostfix).toString(), new TypeReference<ArrayList<Collection<AphiaRecord>>>(){}), requestNames));
                    requestUrl = new StringBuilder(requestPrefix);
                    requestNames = 0L;
                }
                if (requestNames != 0L) {
                    requestUrl.append(requestNameDelimiter);
                }
                requestUrl.append(scientificNameEncoded);
                ++requestNames;
            }
            catch (UnsupportedEncodingException e) {
                throw new WormsClientException(e);
            }
        }
        totalResult.addAll(this.ensureEmptyCollections((List)this.request(requestUrl.append(requestPostfix).toString(), new TypeReference<ArrayList<Collection<AphiaRecord>>>(){}), requestNames));
        return totalResult;
    }
}

