/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.wormsplugin.capabilities;

import de.uni_jena.cs.fusion.client.worms.AphiaRecord;
import de.uni_jena.cs.fusion.client.worms.Source;
import de.uni_jena.cs.fusion.client.worms.Vernacular;
import de.uni_jena.cs.fusion.client.worms.WormsClientException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gcube.data.spd.model.CommonName;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.Conditions;
import org.gcube.data.spd.model.exceptions.ExternalRepositoryException;
import org.gcube.data.spd.model.exceptions.IdNotValidException;
import org.gcube.data.spd.model.exceptions.MethodNotSupportedException;
import org.gcube.data.spd.model.products.TaxonomyItem;
import org.gcube.data.spd.model.products.TaxonomyStatus;
import org.gcube.data.spd.model.util.ElementProperty;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.writers.ClosableWriter;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;
import org.gcube.data.spd.wormsplugin.Utils;
import org.gcube.data.spd.wormsplugin.WormsPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassificationCapabilityImpl
extends ClassificationCapability {
    private static Logger logger = LoggerFactory.getLogger(ClassificationCapabilityImpl.class);

    public Set<Conditions> getSupportedProperties() {
        return Collections.emptySet();
    }

    public List<TaxonomyItem> retrieveTaxonChildrenByTaxonId(String id) throws IdNotValidException, ExternalRepositoryException {
        ArrayList<TaxonomyItem> list = new ArrayList<TaxonomyItem>();
        try {
            Collection<AphiaRecord> records;
            int offsetlimit = 50;
            int offset = 1;
            do {
                if ((records = WormsPlugin.wormsClient.aphiaChildrenByAphiaId(Long.parseLong(id), false, offset)) != null) {
                    for (AphiaRecord record : records) {
                        TaxonomyItem item = this.createItem(record, false);
                        if (item == null) continue;
                        list.add(item);
                    }
                }
                offset += 50;
            } while (records != null && records.size() == 50);
        }
        catch (NumberFormatException e) {
            logger.error("id not valid", (Throwable)e);
            throw new IdNotValidException((Throwable)e);
        }
        catch (Throwable e) {
            logger.error("error contacting worms service", e);
            throw new ExternalRepositoryException(e);
        }
        return list;
    }

    public void retrieveTaxa(ObjectWriter<TaxonomyItem> writer, String word, RecordType type) throws ExternalRepositoryException {
        HashSet<Long> hash = new HashSet<Long>();
        try {
            Collection<AphiaRecord> records = null;
            int offsetlimit = 50;
            int offset = 1;
            do {
                switch (type) {
                    case SCIENTIFIC: {
                        records = WormsPlugin.wormsClient.aphiaRecordsByName(word, true, false, offset);
                        break;
                    }
                    case VERNACULAR: {
                        records = WormsPlugin.wormsClient.aphiaRecordsByVernacular(word, true, offset);
                        break;
                    }
                    default: {
                        logger.warn("invalid record type");
                    }
                }
                if (records != null) {
                    for (AphiaRecord record : records) {
                        if (hash.contains(record.aphiaId)) continue;
                        hash.add(record.aphiaId);
                        TaxonomyItem item = this.createItem(record, true);
                        if (item == null || !writer.isAlive()) continue;
                        writer.write((Object)item);
                    }
                }
                offset += 50;
            } while (records != null && records.size() == 50);
        }
        catch (Throwable e) {
            logger.error("error contacting worms service", e);
            throw new ExternalRepositoryException(e);
        }
    }

    private TaxonomyItem createItem(AphiaRecord record, Boolean flag) throws WormsClientException {
        TaxonomyItem item = null;
        String scientificname = record.scientificName;
        if (scientificname != null) {
            item = new TaxonomyItem(record.aphiaId + "");
            item.setScientificName(record.scientificName);
            item.setScientificNameAuthorship(record.authority);
            item.setLsid(record.lsid);
            item.setCredits(Utils.createCredits());
            item.setCitation(record.citation);
            if (record.taxonomicRank != null) {
                item.setRank(record.taxonomicRank);
            } else if (record.scientificName.equals("Biota")) {
                item.setRank("Superdomain");
            }
            ArrayList<CommonName> listCommNames = new ArrayList<CommonName>();
            Collection<Vernacular> vernaculars = WormsPlugin.wormsClient.aphiaVernacularsByAphiaId(record.aphiaId);
            if (vernaculars != null) {
                for (Vernacular vernacular : vernaculars) {
                    if (vernacular.languageCode == null) continue;
                    CommonName a = new CommonName(vernacular.language, vernacular.vernacular);
                    listCommNames.add(a);
                }
            }
            item.setCommonNames(listCommNames);
            try {
                if (record.status.equals("accepted")) {
                    item.setStatus(new TaxonomyStatus("accepted", TaxonomyStatus.Status.ACCEPTED));
                } else if (record.status.equals("unaccepted") && WormsPlugin.wormsClient.aphiaRecordByAphiaId((long)record.validAphiaId).status.equals("accepted")) {
                    item.setStatus(new TaxonomyStatus(TaxonomyStatus.Status.SYNONYM, record.validAphiaId + "", "synonym"));
                } else {
                    item.setStatus(new TaxonomyStatus(record.status, TaxonomyStatus.Status.UNKNOWN));
                }
            }
            catch (Exception e) {
                item.setStatus(new TaxonomyStatus(record.status, TaxonomyStatus.Status.UNKNOWN));
            }
            if (flag.booleanValue()) {
                try {
                    item.setParent(Utils.retrieveTaxonomy(WormsPlugin.wormsClient.aphiaClassificationByAphiaId(record.aphiaId), record.aphiaId));
                }
                catch (Exception e) {
                    item.setParent(null);
                }
            } else {
                item.setParent(null);
            }
            Collection<Source> sources = null;
            sources = WormsPlugin.wormsClient.aphiaSourcesByAphiaId(record.aphiaId);
            if (sources != null) {
                for (Source source : sources) {
                    if (source == null || source.reference == null) continue;
                    StringBuilder p = new StringBuilder();
                    p.append(source.reference);
                    if (source.link != null) {
                        p.append(", available online at ");
                        p.append(source.link);
                    }
                    if (source.url != null) {
                        p.append(", details: ");
                        p.append(source.url);
                    }
                    ElementProperty property = new ElementProperty(source.use, p.toString());
                    item.addProperty(property);
                }
            }
        }
        return item;
    }

    public void retrieveTaxonByIds(Iterator<String> ids, ClosableWriter<TaxonomyItem> writer) throws ExternalRepositoryException {
        try {
            String id;
            TaxonomyItem tax;
            while (ids.hasNext() && (tax = this.retrieveTaxonById(id = ids.next())) != null && writer.isAlive()) {
                writer.write((Object)tax);
            }
        }
        catch (IdNotValidException e) {
            logger.error("IdNotValidn", (Throwable)e);
        }
        catch (ExternalRepositoryException e) {
            logger.error("ExternalRepositoryException", (Throwable)e);
            throw e;
        }
        finally {
            writer.close();
        }
    }

    public TaxonomyItem retrieveTaxonById(String id) throws IdNotValidException, ExternalRepositoryException {
        TaxonomyItem tax = null;
        AphiaRecord record = null;
        try {
            record = WormsPlugin.wormsClient.aphiaRecordByAphiaId(Long.parseLong(id));
            if (record != null) {
                tax = this.createItem(record, true);
            }
        }
        catch (NumberFormatException e) {
            logger.error("NumberFormatException", (Throwable)e);
            throw new IdNotValidException((Throwable)e);
        }
        catch (WormsClientException e) {
            logger.error("Remote Error", (Throwable)e);
            throw new ExternalRepositoryException((Throwable)e);
        }
        return tax;
    }

    public void getSynonymnsById(ObjectWriter<TaxonomyItem> writer, String id) throws IdNotValidException, MethodNotSupportedException, ExternalRepositoryException {
        try {
            Collection<AphiaRecord> records = null;
            records = WormsPlugin.wormsClient.aphiaSynonymsByAphiaId(Long.parseLong(id));
            if (records != null) {
                AphiaRecord record;
                TaxonomyItem tax;
                Iterator<AphiaRecord> iterator = records.iterator();
                while (iterator.hasNext() && (tax = this.createItem(record = iterator.next(), true)) != null && writer.isAlive()) {
                    writer.write((Object)tax);
                }
            }
        }
        catch (Exception e) {
            logger.error("General Error", (Throwable)e);
            throw new ExternalRepositoryException((Throwable)e);
        }
    }

    public void searchByScientificName(String word, ObjectWriter<TaxonomyItem> writer, Condition ... properties) throws ExternalRepositoryException {
        this.retrieveTaxa(writer, word, RecordType.SCIENTIFIC);
    }

    public static enum RecordType {
        SCIENTIFIC,
        VERNACULAR;

    }
}

