/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.wormsplugin.capabilities;

import aphia.v1_0.worms.AphiaRecord;
import aphia.v1_0.worms.Source;
import aphia.v1_0.worms.Vernacular;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gcube.data.spd.model.CommonName;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.Conditions;
import org.gcube.data.spd.model.exceptions.ExternalRepositoryException;
import org.gcube.data.spd.model.exceptions.IdNotValidException;
import org.gcube.data.spd.model.exceptions.MethodNotSupportedException;
import org.gcube.data.spd.model.products.TaxonomyItem;
import org.gcube.data.spd.model.products.TaxonomyStatus;
import org.gcube.data.spd.model.util.ElementProperty;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.writers.ClosableWriter;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;
import org.gcube.data.spd.wormsplugin.Utils;
import org.gcube.data.spd.wormsplugin.WormsPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassificationCapabilityImpl
extends ClassificationCapability {
    private static Logger logger = LoggerFactory.getLogger(ClassificationCapabilityImpl.class);

    public Set<Conditions> getSupportedProperties() {
        return Collections.emptySet();
    }

    public List<TaxonomyItem> retrieveTaxonChildrenByTaxonId(String id) throws IdNotValidException, ExternalRepositoryException {
        ArrayList<TaxonomyItem> list = new ArrayList<TaxonomyItem>();
        try {
            AphiaRecord[] records;
            int offsetlimit = 50;
            int offset = 1;
            do {
                if ((records = WormsPlugin.binding.getAphiaChildrenByID(Integer.parseInt(id), offset)) != null) {
                    for (AphiaRecord record : records) {
                        TaxonomyItem item = this.createItem(record, false);
                        if (item == null) continue;
                        list.add(item);
                    }
                }
                offset += 50;
            } while (records != null && records.length == 50);
        }
        catch (NumberFormatException e) {
            logger.error("id not valid", (Throwable)e);
            throw new IdNotValidException((Throwable)e);
        }
        catch (Throwable e) {
            logger.error("error contacting worms service", e);
            throw new ExternalRepositoryException(e);
        }
        return list;
    }

    public void retrieveTaxa(ObjectWriter<TaxonomyItem> writer, String word, RecordType type) throws ExternalRepositoryException {
        HashSet<Integer> hash = new HashSet<Integer>();
        try {
            AphiaRecord[] records = null;
            int offsetlimit = 50;
            int offset = 1;
            do {
                switch (type) {
                    case SCIENTIFIC: {
                        records = WormsPlugin.binding.getAphiaRecords(word, true, false, false, offset);
                        break;
                    }
                    case VERNACULAR: {
                        records = WormsPlugin.binding.getAphiaRecordsByVernacular(word, true, offset);
                        break;
                    }
                    default: {
                        logger.warn("invalid record type");
                    }
                }
                if (records != null) {
                    for (AphiaRecord record : records) {
                        if (hash.contains(record.getAphiaID())) continue;
                        hash.add(record.getAphiaID());
                        TaxonomyItem item = this.createItem(record, true);
                        if (item == null || !writer.isAlive()) continue;
                        writer.write((Object)item);
                    }
                }
                offset += 50;
            } while (records != null && records.length == 50);
        }
        catch (Throwable e) {
            logger.error("error contacting worms service", e);
            throw new ExternalRepositoryException(e);
        }
    }

    private TaxonomyItem createItem(AphiaRecord record, Boolean flag) throws RemoteException {
        TaxonomyItem item = null;
        String scientificname = record.getScientificname();
        if (scientificname != null) {
            item = new TaxonomyItem(record.getAphiaID() + "");
            item.setScientificName(record.getScientificname());
            item.setScientificNameAuthorship(record.getAuthority());
            item.setLsid(record.getLsid());
            item.setCredits(Utils.createCredits());
            item.setCitation(record.getCitation());
            if (record.getRank() != null) {
                item.setRank(record.getRank());
            } else if (record.getScientificname().equals("Biota")) {
                item.setRank("Superdomain");
            }
            ArrayList<CommonName> listCommNames = new ArrayList<CommonName>();
            Vernacular[] vernaculars = WormsPlugin.binding.getAphiaVernacularsByID(record.getAphiaID());
            if (vernaculars != null) {
                for (Vernacular vernacular : vernaculars) {
                    if (vernacular.getLanguage_code() == null) continue;
                    CommonName a = new CommonName(vernacular.getLanguage(), vernacular.getVernacular());
                    listCommNames.add(a);
                }
            }
            item.setCommonNames(listCommNames);
            try {
                if (record.getStatus().equals("accepted")) {
                    item.setStatus(new TaxonomyStatus("accepted", TaxonomyStatus.Status.ACCEPTED));
                } else if (record.getStatus().equals("unaccepted") && WormsPlugin.binding.getAphiaRecordByID(record.getValid_AphiaID()).getStatus().equals("accepted")) {
                    item.setStatus(new TaxonomyStatus(TaxonomyStatus.Status.SYNONYM, record.getValid_AphiaID() + "", "synonym"));
                } else {
                    item.setStatus(new TaxonomyStatus(record.getStatus(), TaxonomyStatus.Status.UNKNOWN));
                }
            }
            catch (Exception e) {
                item.setStatus(new TaxonomyStatus(record.getStatus(), TaxonomyStatus.Status.UNKNOWN));
            }
            if (flag.booleanValue()) {
                try {
                    item.setParent(Utils.retrieveTaxonomy(WormsPlugin.binding.getAphiaClassificationByID(record.getAphiaID()), record.getAphiaID()));
                }
                catch (Exception e) {
                    item.setParent(null);
                }
            } else {
                item.setParent(null);
            }
            Source[] sources = null;
            sources = WormsPlugin.binding.getSourcesByAphiaID(record.getAphiaID());
            if (sources != null) {
                for (Source source : sources) {
                    if (source == null || source.getReference() == null) continue;
                    StringBuilder p = new StringBuilder();
                    p.append(source.getReference());
                    if (source.getLink() != null) {
                        p.append(", available online at ");
                        p.append(source.getLink());
                    }
                    if (source.getUrl() != null) {
                        p.append(", details: ");
                        p.append(source.getUrl());
                    }
                    ElementProperty property = new ElementProperty(source.getUse(), p.toString());
                    item.addProperty(property);
                }
            }
        }
        return item;
    }

    public void retrieveTaxonByIds(Iterator<String> ids, ClosableWriter<TaxonomyItem> writer) throws ExternalRepositoryException {
        try {
            String id;
            TaxonomyItem tax;
            while (ids.hasNext() && (tax = this.retrieveTaxonById(id = ids.next())) != null && writer.isAlive()) {
                writer.write((Object)tax);
            }
        }
        catch (IdNotValidException e) {
            logger.error("IdNotValidn", (Throwable)e);
        }
        catch (ExternalRepositoryException e) {
            logger.error("ExternalRepositoryException", (Throwable)e);
            throw e;
        }
        finally {
            writer.close();
        }
    }

    public TaxonomyItem retrieveTaxonById(String id) throws IdNotValidException, ExternalRepositoryException {
        TaxonomyItem tax = null;
        AphiaRecord record = null;
        try {
            record = WormsPlugin.binding.getAphiaRecordByID(Integer.parseInt(id));
            if (record != null) {
                tax = this.createItem(record, true);
            }
        }
        catch (NumberFormatException e) {
            logger.error("NumberFormatException", (Throwable)e);
            throw new IdNotValidException((Throwable)e);
        }
        catch (RemoteException e) {
            logger.error("Remote Error", (Throwable)e);
            throw new ExternalRepositoryException((Throwable)e);
        }
        return tax;
    }

    public void getSynonymnsById(ObjectWriter<TaxonomyItem> writer, String id) throws IdNotValidException, MethodNotSupportedException, ExternalRepositoryException {
        try {
            AphiaRecord[] records = null;
            records = WormsPlugin.binding.getAphiaSynonymsByID(Integer.parseInt(id));
            if (records != null) {
                AphiaRecord record;
                TaxonomyItem tax;
                AphiaRecord[] arr$ = records;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (tax = this.createItem(record = arr$[i$], true)) != null && writer.isAlive(); ++i$) {
                    writer.write((Object)tax);
                }
            }
        }
        catch (Exception e) {
            logger.error("General Error", (Throwable)e);
            throw new ExternalRepositoryException((Throwable)e);
        }
    }

    public void searchByScientificName(String word, ObjectWriter<TaxonomyItem> writer, Condition ... properties) throws ExternalRepositoryException {
        this.retrieveTaxa(writer, word, RecordType.SCIENTIFIC);
    }

    public static enum RecordType {
        SCIENTIFIC,
        VERNACULAR;

    }
}

