/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.wormsplugin;

import aphia.v1_0.worms.AphiaRecord;
import aphia.v1_0.worms.Classification;
import aphia.v1_0.worms.Vernacular;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import org.gcube.data.spd.model.CommonName;
import org.gcube.data.spd.model.products.Taxon;
import org.gcube.data.spd.model.products.TaxonomyItem;
import org.gcube.data.spd.model.products.TaxonomyStatus;
import org.gcube.data.spd.wormsplugin.WormsPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    static Logger logger = LoggerFactory.getLogger(Utils.class);

    public static Taxon retrieveTaxon(Classification classification, int aphiaID) {
        Taxon taxon = null;
        while (classification.getAphiaID() != aphiaID) {
            Taxon newTaxon = new Taxon(classification.getAphiaID() + "");
            if (taxon != null) {
                newTaxon.setParent(taxon);
            }
            newTaxon.setRank(classification.getRank());
            newTaxon.setScientificName(classification.getScientificname());
            classification = classification.getChild();
            taxon = newTaxon;
        }
        return taxon;
    }

    public static TaxonomyItem retrieveTaxonomy(Classification classification, int aphiaID) {
        ArrayList<CommonName> listCommNames = new ArrayList<CommonName>();
        TaxonomyItem taxon = null;
        while (classification.getAphiaID() != aphiaID) {
            int id = classification.getAphiaID();
            TaxonomyItem newTaxon = new TaxonomyItem(id + "");
            if (taxon != null) {
                newTaxon.setParent(taxon);
            }
            newTaxon.setRank(classification.getRank());
            newTaxon.setScientificName(classification.getScientificname());
            newTaxon.setCredits(Utils.createCredits());
            AphiaRecord record = null;
            try {
                record = WormsPlugin.binding.getAphiaRecordByID(id);
            }
            catch (Exception e) {
                logger.error("Error getAphiaRecordByID ", (Throwable)e);
            }
            if (record != null) {
                newTaxon.setCitation(record.getCitation());
                newTaxon.setLsid(record.getLsid());
                newTaxon.setScientificNameAuthorship(record.getAuthority());
            }
            try {
                Vernacular[] vernaculars = WormsPlugin.binding.getAphiaVernacularsByID(classification.getAphiaID());
                if (vernaculars != null) {
                    for (Vernacular vernacular : vernaculars) {
                        if (vernacular.getLanguage_code() == null) continue;
                        CommonName a = new CommonName(vernacular.getLanguage(), vernacular.getVernacular());
                        listCommNames.add(a);
                    }
                }
            }
            catch (RemoteException e) {
                logger.error("RemoteException", (Throwable)e);
            }
            newTaxon.setCommonNames(listCommNames);
            newTaxon.setStatus(new TaxonomyStatus("accepted", TaxonomyStatus.Status.ACCEPTED));
            classification = classification.getChild();
            taxon = newTaxon;
        }
        return taxon;
    }

    public static String createDate() {
        Calendar now = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String date = format.format(now.getTime());
        return date;
    }

    public static String createCredits() {
        String cred = WormsPlugin.credits;
        cred = cred.replace("XDATEX", Utils.createDate());
        return cred;
    }
}

