package org.gcube.data.spd.wormsplugin.capabilities;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.plugin.fwk.Properties;
import org.gcube.data.spd.plugin.fwk.capabilities.NamesMappingCapability;
import org.gcube.data.spd.wormsplugin.WormsPlugin;

import aphia.v1_0.AphiaRecord;
import aphia.v1_0.Vernacular;

public class NamesMappingImpl implements NamesMappingCapability{

	private static GCUBELog logger = new GCUBELog(NamesMappingImpl.class);

	@Override
	public Set<Properties> getSupportedProperties() {
		return Collections.emptySet();
	}

	@Override
	public Set<String> commonNameToScientificNamesMapping(String commonName) {

		Set<String> set = new HashSet<String>();

		try {
			AphiaRecord[] records;
			final int offsetlimit=50;
			int offset =1;
			do{
				records =  WormsPlugin.binding.getAphiaRecordsByVernacular(commonName, true, offset);
				if (records!=null){
					//					logger.debug(records.length);
					for (AphiaRecord record : records){
						
						set.add(record.getScientificname());
					}
				}
				offset+=offsetlimit;
			} while (records!=null && records.length==offsetlimit);

		} catch (Throwable e) {
			logger.error("error contacting worms service", e);
		}

		return set;
	}

	@Override
	public Set<String> scientificNameToCommonNamesMapping(String scientificName) {

		Set<String> set = new HashSet<String>();

		try {
			AphiaRecord[] records;
			final int offsetlimit=50;
			int offset =1;
			do{
				records =  WormsPlugin.binding.getAphiaRecords(scientificName, true, false, false, offset);

				if (records!=null){

					for (AphiaRecord record : records){
						Vernacular[] vernaculars = WormsPlugin.binding.getAphiaVernacularsByID(record.getAphiaID());

						if (vernaculars!=null){
						

							for (Vernacular vernacular : vernaculars)
							{
								if (vernacular.getLanguage_code()!=null){
									if ((vernacular.getLanguage_code()).equals("en"))
										set.add(vernacular.getVernacular());								
								}
							}
						}
					}
				}
				offset+=offsetlimit;
			} while (records!=null && records.length==offsetlimit);

		} catch (Throwable e) {
			logger.error("error contacting worms service", e);
		}

		return set;
	}

}
