/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.wormsplugin;

import aphia.v1_0.AphiaNameServiceBindingStub;
import aphia.v1_0.AphiaNameServiceLocator;
import aphia.v1_0.AphiaRecord;
import aphia.v1_0.Source;
import aphia.v1_0.Vernacular;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.rpc.ServiceException;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.plugin.fwk.Capabilities;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.SearchTypes;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.capabilities.NamesMappingCapability;
import org.gcube.data.spd.plugin.fwk.model.CommonName;
import org.gcube.data.spd.plugin.fwk.model.DataProvider;
import org.gcube.data.spd.plugin.fwk.model.DataSet;
import org.gcube.data.spd.plugin.fwk.model.Product;
import org.gcube.data.spd.plugin.fwk.model.ResultItem;
import org.gcube.data.spd.plugin.fwk.util.RepositoryInfo;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;
import org.gcube.data.spd.wormsplugin.Utils;
import org.gcube.data.spd.wormsplugin.capabilities.ClassificationCapabilityImpl;
import org.gcube.data.spd.wormsplugin.capabilities.NamesMappingImpl;

public class WormsPlugin
extends AbstractPlugin {
    private GCUBELog logger = new GCUBELog(WormsPlugin.class);
    public static String credits = "This information object has been generated via the Species Product Discovery service on XDATEX by interfacing with World Register of Marine Species (http://www.marinespecies.org/)";
    public static AphiaNameServiceBindingStub binding;

    public void initialize(GCUBERuntimeResource runtimeResource) throws Exception {
        this.setUseCache(true);
        try {
            binding = (AphiaNameServiceBindingStub)new AphiaNameServiceLocator().getAphiaNameServicePort();
        }
        catch (ServiceException jre) {
            this.logger.error((Object)"error contacting worms service", (Throwable)jre);
            throw jre;
        }
        super.initialize(runtimeResource);
    }

    public Set<Capabilities> getSupportedCapabilities() {
        return new HashSet<Capabilities>(){
            {
                this.add(Capabilities.Classification);
                this.add(Capabilities.NamesMapping);
            }
        };
    }

    public ClassificationCapability getClassificationInterface() {
        return new ClassificationCapabilityImpl();
    }

    public NamesMappingCapability getNamesMappingInterface() {
        return new NamesMappingImpl();
    }

    public Set<SearchTypes> getSupportedSearch() {
        return new HashSet<SearchTypes>(){
            {
                this.add(SearchTypes.ScientificName);
                this.add(SearchTypes.CommonName);
            }
        };
    }

    public void searchByCommonName(String word, ObjectWriter<ResultItem> writer, Property ... properties) {
        this.search(word, writer, "vernacular");
    }

    public void searchByScientificName(String word, ObjectWriter<ResultItem> writer, Property ... properties) {
        this.search(word, writer, "scientific");
    }

    public String getRepositoryName() {
        return "WoRMS";
    }

    public String getDescription() {
        return "Plugin for WoRMS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search(String word, ObjectWriter<ResultItem> writer, String type) {
        try {
            DataProvider dp = new DataProvider("worms");
            dp.setName("Worms");
            AphiaRecord[] records = null;
            ArrayList<CommonName> listCommNames = new ArrayList<CommonName>();
            int offsetlimit = 50;
            int offset = 1;
            do {
                if (type.equals("vernacular")) {
                    records = binding.getAphiaRecordsByVernacular(word, true, offset);
                } else if (type.equals("scientific")) {
                    records = binding.getAphiaRecords(word, true, false, false, offset);
                }
                if (records != null) {
                    block6: for (AphiaRecord record : records) {
                        Source[] sources = null;
                        if (record == null || (sources = binding.getSourcesByAphiaID(record.getAphiaID())) == null) continue;
                        for (Source source : sources) {
                            Vernacular[] vernaculars;
                            if (source == null || source.getReference() == null) continue;
                            DataSet ds = new DataSet(record.getAphiaID() + "||" + source.getReference().hashCode());
                            ds.setName(source.getReference());
                            if (source.getUrl() != null) {
                                ds.setCitation(source.getUrl());
                            }
                            ds.setDataProvider(dp);
                            ResultItem item = new ResultItem(record.getAphiaID() + "", record.getScientificname());
                            AphiaRecord[] synonyms = binding.getAphiaSynonymsByID(record.getAphiaID());
                            if (synonyms != null && synonyms.length > 0) {
                                Product product = new Product(Capabilities.Synonims, item.getId());
                                product.setCount(synonyms.length);
                                item.setProducts(Collections.singletonList(product));
                            }
                            if ((vernaculars = binding.getAphiaVernacularsByID(record.getAphiaID())) != null) {
                                for (Vernacular vernacular : vernaculars) {
                                    if (vernacular.getLanguage_code() == null) continue;
                                    CommonName a = new CommonName(vernacular.getLanguage(), vernacular.getVernacular());
                                    listCommNames.add(a);
                                }
                            }
                            item.setAuthor(record.getAuthority());
                            item.setLsid(record.getLsid());
                            item.setCitation(record.getCitation());
                            item.setCredits(Utils.createCredits());
                            item.setCommonNames(listCommNames);
                            item.setDataSet(ds);
                            item.setRank(record.getRank());
                            item.setParent(Utils.retrieveTaxon(binding.getAphiaClassificationByID(record.getAphiaID()), record.getAphiaID()));
                            if (!writer.isAlive()) continue block6;
                            writer.write((Object)item);
                        }
                    }
                }
                offset += 50;
            } while (records != null && records.length == 50);
        }
        catch (Throwable e) {
            this.logger.error((Object)"error contacting worms service", e);
        }
        finally {
            writer.close();
        }
    }

    public RepositoryInfo getRepositoryInfo() {
        RepositoryInfo info = new RepositoryInfo("http://www.marinespecies.org/images/banner1.jpg", "http://www.marinespecies.org/", "The World Register of Marine Species (WoRMS) is a database that hopes to provide an authoritative and comprehensive list of names of marine organisms. The content of the registry is edited and maintained by scientific specialists on each group of organism. These taxonomists control the quality of the information, which is gathered from several regional and taxon-specific databases. WoRMS maintains valid names of all marine organisms, but also provides information on synonyms and invalid names. WoRMS is continuously updated since new species are constantly being discovered and described by scientists. In addition, the nomenclature and taxonomy of existing species is often corrected or changed as new research is constantly being published. WoRMS maintenance and development relies on financial contributions, the time contributed by its editorial board, and support of its host institution VLIZ.");
        return info;
    }
}

