package org.gcube.data.spd.wormsplugin;

import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.plugin.fwk.model.CommonName;
import org.gcube.data.spd.plugin.fwk.model.Taxon;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyStatus;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyStatus.Status;

import aphia.v1_0.Classification;
import aphia.v1_0.Vernacular;

public class Utils {

	static GCUBELog logger = new GCUBELog(Utils.class);

	public static Taxon retrieveTaxon(Classification classification, int aphiaID){
		Taxon taxon = null;
		while (classification.getAphiaID()!=aphiaID){
			Taxon newTaxon = new Taxon(classification.getAphiaID()+"");
			if (taxon!=null) 
				newTaxon.setParent(taxon);
			newTaxon.setRank(classification.getRank());
			//			logger.trace(classification.getRank());
			//			logger.trace(classification.getScientificname());
			newTaxon.setScientificName(classification.getScientificname());
			classification = classification.getChild();
			taxon = newTaxon;
		}
		//		logger.trace(taxon);
		return taxon;
	}


	public static TaxonomyItem retrieveTaxonomy(Classification classification, int aphiaID){
		List<CommonName> listCommNames = new ArrayList<CommonName> ();
		TaxonomyItem taxon = null;
	
		while (classification.getAphiaID()!=aphiaID){
//			AphiaRecord rec = null;
			TaxonomyItem newTaxon = new TaxonomyItem(classification.getAphiaID()+"");
			if (taxon!=null) 
				newTaxon.setParent(taxon);
			newTaxon.setRank(classification.getRank());
			//			logger.trace(classification.getRank());
			newTaxon.setScientificName(classification.getScientificname());

			Vernacular[] vernaculars;
			try {
				vernaculars = WormsPlugin.binding.getAphiaVernacularsByID(classification.getAphiaID());
				if (vernaculars!=null){
					//					logger.debug("found vernacular name");
					for (Vernacular vernacular : vernaculars) {										
						if (vernacular.getLanguage_code()!=null){
							CommonName a = new CommonName(vernacular.getLanguage(),vernacular.getVernacular());
							listCommNames.add(a);		
						}
					}
				}
			} catch (RemoteException e) {
				logger.error("RemoteException", e);
			}
			
				newTaxon.setCommonNames(listCommNames);
				
//				try {
//					rec = WormsPlugin.binding.getAphiaRecordByID(classification.getAphiaID());
////					logger.trace(rec.getStatus());
//					if (rec.getStatus().equals("accepted"))
						newTaxon.setStatus(new TaxonomyStatus("accepted", Status.ACCEPTED));
//					else
//						newTaxon.setStatus(new TaxonomyStatus(rec.getStatus(), Status.UNKNOWN));
//					
//				} catch (RemoteException e) {
//					logger.error("RemoteException", e);
//				}

			classification = classification.getChild();
			taxon = newTaxon;
		}
		return taxon;
	}
	
	//format date
	public static String createDate() {
		Calendar now = Calendar.getInstance();
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		String date = format.format(now.getTime());
		return date;
	}

//	public static String createCitation() {
//		StringBuilder cit = new StringBuilder();
//		cit.append(WormsPlugin.citation);
//		cit.append(createDate());
//		return cit.toString();
//	}

	public static String createCredits() {
		String cred = WormsPlugin.credits;
		cred = cred.replace("XDATEX",createDate());	
		return cred;
	}
}
