/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.wormsplugin.capabilities;

import aphia.v1_0.AphiaRecord;
import aphia.v1_0.Vernacular;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.plugin.fwk.Properties;
import org.gcube.data.spd.plugin.fwk.capabilities.NamesMappingCapability;
import org.gcube.data.spd.wormsplugin.WormsPlugin;

public class NamesMappingImpl
implements NamesMappingCapability {
    private static GCUBELog logger = new GCUBELog(NamesMappingImpl.class);

    public Set<Properties> getSupportedProperties() {
        return Collections.emptySet();
    }

    public Set<String> commonNameToScientificNamesMapping(String commonName) {
        HashSet<String> set = new HashSet<String>();
        try {
            AphiaRecord[] records;
            int offsetlimit = 50;
            int offset = 1;
            do {
                if ((records = WormsPlugin.binding.getAphiaRecordsByVernacular(commonName, true, offset)) != null) {
                    for (AphiaRecord record : records) {
                        set.add(record.getScientificname());
                    }
                }
                offset += 50;
            } while (records != null && records.length == 50);
        }
        catch (Throwable e) {
            logger.error((Object)"error contacting worms service", e);
        }
        return set;
    }

    public Set<String> scientificNameToCommonNamesMapping(String scientificName) {
        HashSet<String> set = new HashSet<String>();
        try {
            AphiaRecord[] records;
            int offsetlimit = 50;
            int offset = 1;
            do {
                if ((records = WormsPlugin.binding.getAphiaRecords(scientificName, true, false, false, offset)) != null) {
                    for (AphiaRecord record : records) {
                        Vernacular[] vernaculars = WormsPlugin.binding.getAphiaVernacularsByID(record.getAphiaID());
                        if (vernaculars == null) continue;
                        for (Vernacular vernacular : vernaculars) {
                            if (vernacular.getLanguage_code() == null || !vernacular.getLanguage_code().equals("en")) continue;
                            set.add(vernacular.getVernacular());
                        }
                    }
                }
                offset += 50;
            } while (records != null && records.length == 50);
        }
        catch (Throwable e) {
            logger.error((Object)"error contacting worms service", e);
        }
        return set;
    }
}

