/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.wormsplugin.capabilities;

import aphia.v1_0.AphiaRecord;
import aphia.v1_0.Source;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.stubs.model.DataProvider;
import org.gcube.data.spd.stubs.model.DataSet;
import org.gcube.data.spd.stubs.model.Product;
import org.gcube.data.spd.stubs.model.ResultItem;
import org.gcube.data.spd.stubs.pluginhelper.Capabilities;
import org.gcube.data.spd.stubs.pluginhelper.Properties;
import org.gcube.data.spd.stubs.pluginhelper.capabilities.SynonimsCapability;
import org.gcube.data.spd.stubs.pluginhelper.writers.ObjectWriter;
import org.gcube.data.spd.wormsplugin.Utils;
import org.gcube.data.spd.wormsplugin.WormsPlugin;

public class SynonimsCapabilityImpl
implements SynonimsCapability {
    private static GCUBELog logger = new GCUBELog(SynonimsCapabilityImpl.class);

    public Set<Properties> getSupportedProperties() {
        return Collections.emptySet();
    }

    public void getSynonimnsByIds(ObjectWriter<ResultItem> writer, String ... ids) {
        DataProvider dp = new DataProvider("worms");
        dp.setName("Worms");
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            try {
                AphiaRecord[] records;
                AphiaRecord[] aphiaRecordArray = records = WormsPlugin.binding.getAphiaSynonymsByID(Integer.parseInt(id));
                int n3 = records.length;
                int n4 = 0;
                while (n4 < n3) {
                    AphiaRecord record = aphiaRecordArray[n4];
                    logger.debug((Object)"found record in worms");
                    Source[] sourceArray = WormsPlugin.binding.getSourcesByAphiaID(record.getAphiaID());
                    int n5 = sourceArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        Source source = sourceArray[n6];
                        logger.debug((Object)"found source in worms");
                        if (source.getReference() != null) {
                            logger.debug((Object)"source has fulltext not null");
                            DataSet ds = new DataSet(String.valueOf(record.getAphiaID()) + "||" + source.getReference().hashCode());
                            ds.setName(source.getReference());
                            if (source.getUrl() != null) {
                                ds.setCitation(source.getUrl());
                            }
                            ds.setDataProvider(dp);
                            ResultItem item = new ResultItem(String.valueOf(record.getAphiaID()), record.getScientificname());
                            Calendar now = Calendar.getInstance();
                            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                            String credits = "Biodiversity data published by: " + ds.getName() + " (Accessed through WoRMS web service, " + format.format(now.getTime()) + ")";
                            Product product = new Product(Capabilities.Synonims, item.getId());
                            item.setProducts(Collections.singletonList(product));
                            item.setCredits(credits);
                            item.setCitation(record.getCitation());
                            item.setDataSet(ds);
                            item.setRank(record.getRank());
                            item.setParent(Utils.retrieveTaxon(WormsPlugin.binding.getAphiaClassificationByID(record.getAphiaID()), record.getAphiaID()));
                            writer.put((Object)item);
                        }
                        ++n6;
                    }
                    ++n4;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
    }
}

