/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.wormsplugin;

import aphia.v1_0.AphiaNameServiceBindingStub;
import aphia.v1_0.AphiaNameServiceLocator;
import aphia.v1_0.AphiaRecord;
import aphia.v1_0.Source;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Set;
import javax.xml.rpc.ServiceException;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.stubs.model.DataProvider;
import org.gcube.data.spd.stubs.model.DataSet;
import org.gcube.data.spd.stubs.model.Product;
import org.gcube.data.spd.stubs.model.ResultItem;
import org.gcube.data.spd.stubs.pluginhelper.AbstractPlugin;
import org.gcube.data.spd.stubs.pluginhelper.Capabilities;
import org.gcube.data.spd.stubs.pluginhelper.Property;
import org.gcube.data.spd.stubs.pluginhelper.SearchTypes;
import org.gcube.data.spd.stubs.pluginhelper.writers.ObjectWriter;
import org.gcube.data.spd.wormsplugin.Utils;

public class WormsPlugin
extends AbstractPlugin {
    private GCUBELog logger = new GCUBELog(WormsPlugin.class);
    public static AphiaNameServiceBindingStub binding;

    public void initialize(GCUBERuntimeResource runtimeResource) throws Exception {
        try {
            binding = (AphiaNameServiceBindingStub)new AphiaNameServiceLocator().getAphiaNameServicePort();
        }
        catch (ServiceException jre) {
            this.logger.error((Object)"error contacting worms service", (Throwable)jre);
            throw jre;
        }
    }

    public Set<SearchTypes> getSupportedSearch() {
        return Collections.singleton(SearchTypes.ScientificName);
    }

    public void searchByCommonName(String word, ObjectWriter<ResultItem> writer, Property ... properties) {
    }

    public void searchByScientificName(String word, ObjectWriter<ResultItem> writer, Property ... properties) {
        try {
            AphiaRecord[] records;
            DataProvider dp = new DataProvider("worms");
            dp.setName("Worms");
            int offsetlimit = 50;
            int offset = 1;
            do {
                if ((records = binding.getAphiaRecords(word, true, false, false, offset)) != null) {
                    AphiaRecord[] aphiaRecordArray = records;
                    int n = records.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AphiaRecord record = aphiaRecordArray[n2];
                        this.logger.debug((Object)"found record in worms");
                        Source[] sourceArray = binding.getSourcesByAphiaID(record.getAphiaID());
                        int n3 = sourceArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Source source = sourceArray[n4];
                            this.logger.debug((Object)"found source in worms");
                            if (source.getReference() != null) {
                                this.logger.debug((Object)"source has fulltext not null");
                                DataSet ds = new DataSet(String.valueOf(record.getAphiaID()) + "||" + source.getReference().hashCode());
                                ds.setName(source.getReference());
                                if (source.getUrl() != null) {
                                    ds.setCitation(source.getUrl());
                                }
                                ds.setDataProvider(dp);
                                ResultItem item = new ResultItem(String.valueOf(record.getAphiaID()), record.getScientificname());
                                Calendar now = Calendar.getInstance();
                                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                                String credits = "Biodiversity data published by: " + ds.getName() + " (Accessed through WoRMS web service, " + format.format(now.getTime()) + ")";
                                Product product = new Product(Capabilities.Synonims, item.getId());
                                product.setCount(binding.getAphiaSynonymsByID(record.getAphiaID()).length);
                                item.setProducts(Collections.singletonList(product));
                                item.setCredits(credits);
                                item.setCitation(record.getCitation());
                                item.setDataSet(ds);
                                item.setRank(record.getRank());
                                item.setParent(Utils.retrieveTaxon(binding.getAphiaClassificationByID(record.getAphiaID()), record.getAphiaID()));
                                writer.put((Object)item);
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
                offset += 50;
            } while (records != null && records.length == 50);
        }
        catch (Throwable e) {
            this.logger.error((Object)"error contacting worms service", e);
        }
        writer.close();
    }

    public String getRepositoryName() {
        return "WoRMS";
    }

    public String getDescription() {
        return "Plugin for WoRMS";
    }
}

